/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph;

import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xyz.nifeather.morph.FeatherMorphBootstrap;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.RequestManager;
import xyz.nifeather.morph.RevealingHandler;
import xyz.nifeather.morph.abilities.AbilityManager;
import xyz.nifeather.morph.api.FeatherMorphAPI;
import xyz.nifeather.morph.api.networking.exceptions.PluginDisabledException;
import xyz.nifeather.morph.commands.MorphCommandManager;
import xyz.nifeather.morph.config.ConfigOption;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.events.CommonEventProcessor;
import xyz.nifeather.morph.events.CustomItemRelatedEvents;
import xyz.nifeather.morph.events.DisguiseAnimationProcessor;
import xyz.nifeather.morph.events.EntityProcessor;
import xyz.nifeather.morph.events.ForcedDisguiseProcessor;
import xyz.nifeather.morph.events.InteractionMirrorProcessor;
import xyz.nifeather.morph.events.PlayerSkinProcessor;
import xyz.nifeather.morph.events.PlayerTracker;
import xyz.nifeather.morph.events.RevealingEventProcessor;
import xyz.nifeather.morph.events.WorkaroundProcessor;
import xyz.nifeather.morph.events.mirror.ExecutorHub;
import xyz.nifeather.morph.interfaces.IManagePlayerData;
import xyz.nifeather.morph.interfaces.IManageRequests;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.MorphMessageStore;
import xyz.nifeather.morph.messages.vanilla.VanillaMessageStore;
import xyz.nifeather.morph.misc.ModNetworkingHelper;
import xyz.nifeather.morph.misc.PlayerOperationSimulator;
import xyz.nifeather.morph.misc.RecipeConfigHandle;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.gui.IconLookup;
import xyz.nifeather.morph.misc.integrations.pingwheel.PingWheelAdapter;
import xyz.nifeather.morph.misc.integrations.placeholderapi.PlaceholderIntegration;
import xyz.nifeather.morph.misc.integrations.residence.ResidenceEventProcessor;
import xyz.nifeather.morph.misc.integrations.towny.TownyAdapter;
import xyz.nifeather.morph.network.multiInstance.MultiInstanceService;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.platform.CurrentPlatform;
import xyz.nifeather.morph.platform.impl.paper.PaperPlatform;
import xyz.nifeather.morph.shaded.bstats.bukkit.Metrics;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.shaded.pluginbase.Messages.MessageStore;
import xyz.nifeather.morph.shaded.pluginbase.ScheduleInfo;
import xyz.nifeather.morph.shaded.pluginbase.XiaMoJavaPlugin;
import xyz.nifeather.morph.skills.SkillManager;
import xyz.nifeather.morph.storage.skill.SkillsConfigurationStoreNew;
import xyz.nifeather.morph.updates.UpdateHandler;
import xyz.nifeather.morph.utilities.FoliaThreadUtils;

public final class FeatherMorphMain
extends XiaMoJavaPlugin {
    private static FeatherMorphMain instance;
    private final Bindable<Boolean> debugOutput = new Bindable<Boolean>(false);
    private MorphCommandManager cmdHelper;
    private MorphManager morphManager;
    private PluginManager pluginManager;
    private SkillManager skillHandler;
    private AbilityManager abilityManager;
    private VanillaMessageStore vanillaMessageStore;
    private MorphMessageStore messageStore;
    private PlaceholderIntegration placeholderIntegration;
    private MorphClientHandler clientHandler;
    private Metrics metrics;
    private MultiInstanceService instanceService;
    @Nullable
    private EntityProcessor entityProcessor;
    private ExecutorHub mirrorExecutorHub;
    private static final String noticeHeaderFooter = "- x - x - x - x - x - x - x - x - x - x - x - x -";
    @ApiStatus.Internal
    public int execSchedules = 0;
    private final AtomicBoolean pluginEnableDone = new AtomicBoolean(false);

    public PaperPlatform getPlatform() {
        return CurrentPlatform.instance();
    }

    public static FeatherMorphMain getInstance() {
        return instance;
    }

    public FeatherMorphMain() {
        instance = this;
        CurrentPlatform.instance();
        if (this.isFolia()) {
            this.logger.info("We are running on a Folia server!");
        }
    }

    public static String getMorphNameSpace() {
        return "morphplugin";
    }

    @Override
    public String getNamespace() {
        return FeatherMorphMain.getMorphNameSpace();
    }

    public boolean debugOutputEnabled() {
        return this.debugOutput.get();
    }

    public boolean isFolia() {
        return FoliaThreadUtils.isFolia();
    }

    private void printImportantWarning(boolean critical, String ... warnings) {
        if (critical) {
            this.logger.error(noticeHeaderFooter);
            this.logger.error("");
            for (String warning : warnings) {
                this.logger.error(warning);
            }
            this.logger.error("");
            this.logger.error(noticeHeaderFooter);
        } else {
            this.logger.warn(noticeHeaderFooter);
            this.logger.warn("");
            for (String warning : warnings) {
                this.logger.warn(warning);
            }
            this.logger.warn("");
            this.logger.warn(noticeHeaderFooter);
        }
    }

    @Override
    public ScheduleInfo schedule(Runnable function, int delay, boolean async) {
        ++this.execSchedules;
        return super.schedule(function, delay, async);
    }

    @ApiStatus.Internal
    public static void panic(String ... message) {
        FeatherMorphMain plugin = FeatherMorphMain.getInstance();
        Logger logger = plugin.getSLF4JLogger();
        logger.error("- x - x - x - x - x - x - x - x - x - x - x - x - x - x - x -");
        logger.error("PANIC!");
        for (String s : message) {
            logger.error(s);
        }
        logger.error("- x - x - x - x - x - x - x - x - x - x - x - x - x - x - x -");
        logger.error("Called at {}", (Object)Thread.currentThread().getName());
        logger.error("Invoke stacktrace:");
        Thread.dumpStack();
        logger.error("- x - x - x - x - x - x - x - x - x - x - x - x - x - x - x -");
        FeatherMorphAPI.panic();
        if (plugin.isEnabled()) {
            Bukkit.getPluginManager().disablePlugin((Plugin)FeatherMorphMain.getInstance());
        }
    }

    @Override
    protected void enable() {
        super.enable();
        this.pluginManager = Bukkit.getPluginManager();
        String bukkitVersion = Bukkit.getMinecraftVersion();
        String primaryVersion = "1.21.8";
        String[] compatVersions = new String[]{primaryVersion};
        if (Arrays.stream(compatVersions).noneMatch(bukkitVersion::equals)) {
            this.printImportantWarning(true, "This version of Minecraft (%s) is not supported!".formatted(bukkitVersion), "Please use %s instead!".formatted(primaryVersion));
            FeatherMorphMain.panic("This version of Minecraft is not supported.");
            return;
        }
        if (!bukkitVersion.equals(primaryVersion)) {
            this.printImportantWarning(false, "Minecraft %s is not primary supported!".formatted(bukkitVersion), "We suggest to use %s instead!".formatted(primaryVersion));
        }
        this.metrics = new Metrics(this, 18062);
        this.registerListener(this.softDeps);
        PlayerTracker playerTracker = new PlayerTracker();
        this.softDeps.setHandle("PlaceholderAPI", p -> {
            this.logger.info("Registering Placeholders...");
            this.placeholderIntegration = new PlaceholderIntegration(this.dependencyManager);
            this.placeholderIntegration.register();
        }, true);
        this.softDeps.setHandle("Residence", r -> {
            this.logger.info("Residence detected, applying integrations...");
            this.registerListener(new ResidenceEventProcessor());
        }, true);
        this.softDeps.setHandle("Towny", plugin -> {
            this.logger.info("Towny detected, applying integrations...");
            this.registerListener(new TownyAdapter());
        }, true);
        this.softDeps.setHandle("PingWheelPluginForked", plugin -> {
            this.logger.info("PingWheelPluginForked detected, trying to apply integrations...");
            new PingWheelAdapter();
        }, true);
        this.dependencyManager.cache(this);
        this.clientHandler = new MorphClientHandler();
        this.dependencyManager.cache(this.clientHandler);
        this.dependencyManager.cache(new ModNetworkingHelper());
        this.morphManager = new MorphManager();
        this.dependencyManager.cache(this.morphManager);
        this.skillHandler = new SkillManager();
        this.dependencyManager.cache(this.skillHandler);
        this.abilityManager = new AbilityManager();
        this.dependencyManager.cache(this.abilityManager);
        this.dependencyManager.cache(new RevealingHandler());
        this.vanillaMessageStore = new VanillaMessageStore();
        this.dependencyManager.cache(this.vanillaMessageStore);
        this.messageStore = new MorphMessageStore();
        this.dependencyManager.cacheAs(MessageStore.class, this.messageStore);
        this.dependencyManager.cacheAs(MiniMessage.class, MiniMessage.miniMessage());
        this.dependencyManager.cacheAs(IManagePlayerData.class, this.morphManager);
        this.dependencyManager.cacheAs(IManageRequests.class, new RequestManager());
        this.dependencyManager.cacheAs(Scoreboard.class, Bukkit.getScoreboardManager().getMainScoreboard());
        MorphConfigManager config = new MorphConfigManager(this);
        this.dependencyManager.cacheAs(MorphConfigManager.class, config);
        this.dependencyManager.cache(playerTracker);
        config.bind(this.debugOutput, ConfigOption.DEBUG_OUTPUT);
        this.cmdHelper = new MorphCommandManager();
        this.dependencyManager.cache(this.cmdHelper);
        this.dependencyManager.cache(new SkillsConfigurationStoreNew());
        this.dependencyManager.cache(new MessageUtils());
        this.dependencyManager.cache(new PlayerOperationSimulator());
        UpdateHandler updateHandler = new UpdateHandler();
        this.dependencyManager.cache(updateHandler);
        this.instanceService = new MultiInstanceService();
        this.dependencyManager.cache(this.instanceService);
        this.dependencyManager.cache(DisguiseProperties.INSTANCE);
        this.mirrorExecutorHub = new ExecutorHub();
        this.dependencyManager.cache(this.mirrorExecutorHub);
        InteractionMirrorProcessor mirrorProcessor = new InteractionMirrorProcessor();
        LifecycleEventManager lifecycleManager = this.getLifecycleManager();
        lifecycleManager.registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> this.cmdHelper.register((ReloadableRegistrarEvent<Commands>)event));
        Listener[] listenerArray = new Listener[10];
        listenerArray[0] = playerTracker;
        listenerArray[1] = mirrorProcessor;
        listenerArray[2] = new CommonEventProcessor();
        listenerArray[3] = new CustomItemRelatedEvents();
        listenerArray[4] = new RevealingEventProcessor();
        listenerArray[5] = new DisguiseAnimationProcessor();
        listenerArray[6] = new ForcedDisguiseProcessor();
        listenerArray[7] = new PlayerSkinProcessor();
        listenerArray[8] = new WorkaroundProcessor();
        this.entityProcessor = new EntityProcessor();
        listenerArray[9] = this.entityProcessor;
        Listener[] listeners = listenerArray;
        this.schedule(() -> {
            FeatherMorphAPI api;
            try {
                api = new FeatherMorphAPI(this);
            }
            catch (Exception e) {
                this.logger.error("FeatherMorphAPI failed to load!", (Throwable)e);
                FeatherMorphMain.panic("API failed to load");
                return;
            }
            this.dependencyManager.cache(api);
            this.registerListeners(listeners);
        });
        this.pluginEnableDone.set(true);
        RecipeConfigHandle.handle(this.getDataFolder());
        IconLookup.instance();
    }

    @Override
    public void disable() {
        boolean serverStopping = this.getServer().isStopping();
        if (!serverStopping && this.pluginEnableDone.get()) {
            this.printImportantWarning(true, "HEY, THERE!", "Are you doing a hot reload?", "Note that FeatherMorph does NOT support doing such!", "Before you open any issues, please do a FULL RESTART for your server! We will NOT provide any support after the hot reload!");
        }
        FeatherMorphBootstrap.pluginDisabled.set(true);
        try {
            if (this.entityProcessor != null && !serverStopping && this.entityProcessor.currentlyDoModifyAI() && this.pluginEnableDone.get()) {
                this.printImportantWarning(true, "Disabling/reloading FeatherMorph while modifying AI is not supported", "Expect problems!");
            }
            if (this.morphManager != null) {
                this.morphManager.onPluginDisable();
            }
            if (this.placeholderIntegration != null) {
                this.placeholderIntegration.unregister();
            }
            if (this.clientHandler != null) {
                this.clientHandler.getConnectedPlayers().forEach(p -> this.clientHandler.disconnect((Player)p, new PluginDisabledException("Plugin has been disabled")));
            }
            if (this.metrics != null) {
                this.metrics.shutdown();
            }
            if (this.mirrorExecutorHub != null) {
                this.mirrorExecutorHub.pushToLoggingBase();
            }
            if (this.instanceService != null) {
                this.instanceService.onDisable();
            }
            Messenger messenger = this.getServer().getMessenger();
            messenger.unregisterOutgoingPluginChannel((Plugin)this);
        }
        catch (Exception e) {
            this.logger.warn("Error occurred while disabling", (Throwable)e);
        }
        super.disable();
    }

    private void registerListeners(Listener[] listeners) {
        for (Listener l : listeners) {
            this.registerListener(l);
        }
    }

    private void registerListener(Listener l) {
        this.pluginManager.registerEvents(l, (Plugin)this);
    }

    @Override
    public boolean acceptSchedules() {
        return true;
    }

    @Override
    public void startMainLoop(Runnable r) {
        if (!this.isEnabled()) {
            return;
        }
        Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this, o -> r.run(), 1L, 1L);
    }

    @Override
    public void runAsync(Runnable r) {
        Bukkit.getAsyncScheduler().runNow((Plugin)this, o -> r.run());
    }

    @Override
    protected int getExceptionLimit() {
        return 3;
    }
}

