/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetMobRevealCommand;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.utilities.MathUtils;

public class RevealingHandler
extends MorphPluginObject {
    private static final Random seedRandom = new Random();
    private final Map<UUID, RevealingState> playerRevealingStateMap = new ConcurrentHashMap<UUID, RevealingState>();

    @NotNull
    public RevealingLevel getRevealingLevel(Player player) {
        return this.getRevealingState(player).getRevealingLevel();
    }

    public boolean shouldMobsAwareRevealed(Player player) {
        return this.getRevealingState(player).shouldMobsAwareRevealed();
    }

    public float getRevealingValue(Player player) {
        return this.getRevealingState(player).getBaseValue();
    }

    public void updateStatePlayerInstance(Player newInstance) {
        UUID match = this.playerRevealingStateMap.keySet().stream().filter(k -> k.equals(newInstance.getUniqueId())).findFirst().orElse(null);
        if (match == null) {
            return;
        }
        RevealingState state = this.playerRevealingStateMap.get(match);
        state.player = newInstance;
        this.playerRevealingStateMap.remove(match);
        this.playerRevealingStateMap.put(newInstance.getUniqueId(), state);
    }

    @NotNull
    public RevealingState getRevealingState(Player player) {
        RevealingState state = this.playerRevealingStateMap.getOrDefault(player.getUniqueId(), null);
        if (state == null) {
            state = new RevealingState(player, seedRandom.nextInt());
            this.playerRevealingStateMap.put(player.getUniqueId(), state);
        }
        return state;
    }

    @Initializer
    private void load() {
        this.addSchedule(this::update);
    }

    private void update() {
        this.addSchedule(this::update);
        if (this.playerRevealingStateMap.isEmpty()) {
            return;
        }
        if (this.plugin.getCurrentTick() % 5L == 0L) {
            ArrayList<UUID> playersToRemove = new ArrayList<UUID>();
            this.playerRevealingStateMap.forEach((uuid, state) -> {
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player == null) {
                    if (state.bindingState == null) {
                        playersToRemove.add((UUID)uuid);
                        return;
                    }
                    if (state.bindingState.disposed()) {
                        playersToRemove.add((UUID)uuid);
                    }
                }
            });
            playersToRemove.forEach(this.playerRevealingStateMap::remove);
        }
        boolean decay = this.plugin.getCurrentTick() % 5L == 0L;
        for (RevealingState state2 : this.playerRevealingStateMap.values()) {
            if (decay) {
                state2.addBaseValue((float)(state2.bindingState == null ? 2 : 1) * -0.1f, true);
            }
            if (this.plugin.getCurrentTick() % 10L != 0L) continue;
            state2.notifyUpdates();
        }
    }

    public static class RevealingState
    extends MorphPluginObject {
        private Player player;
        private final int randomSeed;
        @Nullable
        public DisguiseState bindingState;
        private final AtomicBoolean dirty = new AtomicBoolean(false);
        public final Bindable<Float> baseValue = new Bindable<Float>(Float.valueOf(0.0f));
        @Nullable
        private RevealingLevel revealingLevel;
        @Resolved(shouldSolveImmediately=true)
        private MorphClientHandler clientHandler;

        public boolean shouldMobsAwareRevealed() {
            RevealingLevel revealingLevel = this.getRevealingLevel();
            if (revealingLevel == RevealingLevel.SAFE) {
                return false;
            }
            if (revealingLevel == RevealingLevel.REVEALED) {
                return true;
            }
            long revAsLong = Math.round((double)this.baseValue.get().floatValue() * 1000.0);
            Random random = new Random((long)this.randomSeed + revAsLong);
            float triggerValue = this.getBaseValue();
            float randomNext = random.nextFloat(0.0f, 100.0f) + 20.0f;
            return randomNext <= triggerValue;
        }

        public RevealingState(Player player, int randomSeed) {
            this.player = player;
            this.randomSeed = randomSeed;
        }

        @NotNull
        public RevealingLevel getRevealingLevel() {
            if (this.revealingLevel == null) {
                this.revealingLevel = RevealingLevel.fromValue(this.baseValue);
            }
            return this.revealingLevel;
        }

        public float getBaseValue() {
            return this.baseValue.get().floatValue();
        }

        public void setBaseValue(float newVal) {
            newVal = MathUtils.clamp(0.0f, 100.0f, newVal);
            if (!this.dirty.get()) {
                this.dirty.set(newVal != this.baseValue.get().floatValue());
            }
            this.baseValue.set(Float.valueOf(newVal));
            this.revealingLevel = null;
        }

        public void addBaseValue(float diff) {
            this.addBaseValue(diff, false);
        }

        public void addBaseValue(float diff, boolean forceAllowPositiveDiff) {
            if (this.bindingState == null && diff > 0.0f && !forceAllowPositiveDiff) {
                return;
            }
            this.setBaseValue(MathUtils.clamp(0.0f, 100.0f, this.baseValue.get().floatValue() + diff));
        }

        public void setRevealingLevel(RevealingLevel newLv) {
            this.setBaseValue(newLv.getValue());
            this.revealingLevel = newLv;
        }

        public void notifyUpdates() {
            if (!this.dirty.get()) {
                return;
            }
            this.clientHandler.sendCommand(this.player, (AbstractS2CCommand<?>)new S2CSetMobRevealCommand(this.baseValue.get().floatValue()));
            this.dirty.set(false);
        }
    }

    public static enum RevealingLevel {
        SAFE(0.0f),
        SUSPECT(20.0f),
        REVEALED(80.0f);

        private final float val;
        private static final Map<Float, RevealingLevel> valueLevelMap;

        private RevealingLevel(float val) {
            this.val = val;
        }

        public float getValue() {
            return this.val;
        }

        public static RevealingLevel fromValue(Bindable<? extends Number> bindable) {
            return RevealingLevel.fromValue(bindable.get().floatValue());
        }

        public static RevealingLevel fromValue(float val) {
            List<Float> keyArray = valueLevelMap.keySet().stream().filter(f -> val > f.floatValue()).toList();
            return keyArray.isEmpty() ? SAFE : valueLevelMap.getOrDefault(keyArray.getLast(), SAFE);
        }

        static {
            valueLevelMap = new Object2ObjectArrayMap();
            for (RevealingLevel value : RevealingLevel.values()) {
                valueLevelMap.put(Float.valueOf(value.val), value);
            }
        }
    }

    public static class RevealingDiffs {
        public static final float NATURAL_DIFFBASE = 1.0f;
        public static final float NATURAL_DECAY = 0.25f;
        public static final float NATURAL_INCREASEMENT = -0.1f;
        public static final float ON_MOB_TARGET = 0.36f;
        public static final float TAKE_DAMAGE = 1.5f;
        public static final float DEAL_DAMAGE = 0.375f;
        public static final float INTERACT = 0.4f;
        public static final float INTERACT_ENTITY = 0.4f;
        public static final float BLOCK_BREAK = 0.45f;
        public static final float BLOCK_PLACE = 0.45f;
        public static final int ALREADY_TARGETED = Math.round(RevealingLevel.REVEALED.val / 2.0f);
    }
}

