/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.abilities.IAbility;
import xyz.nifeather.morph.abilities.impl.AttributeModifyingAbility;
import xyz.nifeather.morph.abilities.impl.BossbarAbility;
import xyz.nifeather.morph.abilities.impl.BurnsUnderSunAbility;
import xyz.nifeather.morph.abilities.impl.ChatOverrideAbility;
import xyz.nifeather.morph.abilities.impl.DryOutInAirAbility;
import xyz.nifeather.morph.abilities.impl.ExtraAirAbility;
import xyz.nifeather.morph.abilities.impl.FlyAbility;
import xyz.nifeather.morph.abilities.impl.HealsFromEntityAbility;
import xyz.nifeather.morph.abilities.impl.NoFallDamageAbility;
import xyz.nifeather.morph.abilities.impl.NoSweetBushDamageAbility;
import xyz.nifeather.morph.abilities.impl.SmallJumpBoostAbility;
import xyz.nifeather.morph.abilities.impl.SnowyAbility;
import xyz.nifeather.morph.abilities.impl.SpiderAbility;
import xyz.nifeather.morph.abilities.impl.TakesDamageFromWaterAbility;
import xyz.nifeather.morph.abilities.impl.WardenAbility;
import xyz.nifeather.morph.abilities.impl.WardenLessAwareAbility;
import xyz.nifeather.morph.abilities.impl.dmgReduce.ReduceFallDamageAbility;
import xyz.nifeather.morph.abilities.impl.dmgReduce.ReduceMagicDamageAbility;
import xyz.nifeather.morph.abilities.impl.dmgReduce.ReduceWitherDamageAbility;
import xyz.nifeather.morph.abilities.impl.onAttack.ExtraKnockbackAbility;
import xyz.nifeather.morph.abilities.impl.onAttack.PotionOnAttackAbility;
import xyz.nifeather.morph.abilities.impl.potion.BreatheUnderWaterAbility;
import xyz.nifeather.morph.abilities.impl.potion.FeatherFallingAbility;
import xyz.nifeather.morph.abilities.impl.potion.FireResistanceAbility;
import xyz.nifeather.morph.abilities.impl.potion.JumpBoostAbility;
import xyz.nifeather.morph.abilities.impl.potion.NightVisionAbility;
import xyz.nifeather.morph.abilities.impl.potion.SpeedBoostAbility;
import xyz.nifeather.morph.api.events.lifecycle.AbilitiesFinishedInitializeEvent;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;
import xyz.nifeather.morph.storage.skill.SkillAbilityConfigContainer;
import xyz.nifeather.morph.storage.skill.SkillsConfigurationStoreNew;

public class AbilityManager
extends MorphPluginObject {
    private final List<IAbility<?>> registedAbilities = new CopyOnWriteArrayList();
    @Resolved
    private SkillsConfigurationStoreNew store;

    public boolean registerAbility(IAbility<?> ability) {
        if (this.registedAbilities.stream().anyMatch(a -> a.getIdentifier().equals((Object)ability.getIdentifier()))) {
            this.logger.error("Can't register ability: Another ability instance has already registered as " + ability.getIdentifier().asString() + "!");
            return false;
        }
        this.registedAbilities.add(ability);
        Bukkit.getPluginManager().registerEvents(ability, (Plugin)this.plugin);
        return true;
    }

    public List<IAbility<?>> getRegistedAbilities() {
        return new ObjectArrayList(this.registedAbilities);
    }

    public boolean registerAbilities(List<IAbility<?>> abilities) {
        AtomicBoolean success = new AtomicBoolean(false);
        abilities.forEach(a -> {
            if (!this.registerAbility((IAbility<?>)a)) {
                success.set(false);
            }
        });
        return success.get();
    }

    @Initializer
    private void load() {
        this.registerAbilities((List<IAbility<?>>)ObjectList.of((Object[])new IAbility[]{new BreatheUnderWaterAbility(), new BurnsUnderSunAbility(), new FeatherFallingAbility(), new FireResistanceAbility(), new FlyAbility(), new JumpBoostAbility(), new NightVisionAbility(), new NoFallDamageAbility(), new ReduceFallDamageAbility(), new ReduceMagicDamageAbility(), new ReduceWitherDamageAbility(), new SmallJumpBoostAbility(), new SnowyAbility(), new SpeedBoostAbility(), new TakesDamageFromWaterAbility(), new WardenLessAwareAbility(), new WardenAbility(), new ChatOverrideAbility(), new BossbarAbility(), new NoSweetBushDamageAbility(), new AttributeModifyingAbility(), new HealsFromEntityAbility(), new ExtraKnockbackAbility(), new DryOutInAirAbility(), new PotionOnAttackAbility(), new SpiderAbility(), new ExtraAirAbility()}));
        Bukkit.getPluginManager().callEvent((Event)new AbilitiesFinishedInitializeEvent(this));
    }

    @NotNull
    public Map<NamespacedKey, ISkillAbilityOption> getOptionsFor(String disguiseIdentifier) {
        SkillAbilityConfigContainer configuration = (SkillAbilityConfigContainer)this.store.get(disguiseIdentifier);
        if (configuration == null) {
            return new Object2ObjectOpenHashMap();
        }
        ConcurrentHashMap<NamespacedKey, ISkillAbilityOption> optionMap = new ConcurrentHashMap<NamespacedKey, ISkillAbilityOption>();
        configuration.getAbilitiyIdentifiers().forEach(abilityIdString -> {
            NamespacedKey idKey = NamespacedKey.fromString((String)abilityIdString);
            if (idKey == null) {
                this.logger.warn("Invalid ability ID: %s".formatted(abilityIdString));
                return;
            }
            IAbility<?> abilityInstance = this.getAbility(idKey);
            if (abilityInstance == null) {
                return;
            }
            Object options = null;
            try {
                options = configuration.readOptions(abilityInstance);
            }
            catch (ParseErrorException e) {
                this.logger.warn("Failed to parse ability configuration for '%s' under '%s'".formatted(abilityIdString, disguiseIdentifier), (Throwable)e);
            }
            if (options != null) {
                optionMap.put(idKey, (ISkillAbilityOption)options);
            } else {
                this.logger.warn("Null option for ability %s under %s, is everything correct?".formatted(abilityInstance.getIdentifier(), disguiseIdentifier));
            }
        });
        return optionMap;
    }

    @Nullable
    public IAbility<?> getAbility(@Nullable NamespacedKey abilityIdentifier) {
        if (abilityIdentifier == null) {
            return null;
        }
        IAbility val = this.registedAbilities.stream().filter(a -> a.getIdentifier().equals((Object)abilityIdentifier)).findFirst().orElse(null);
        if (val == null) {
            this.logger.warn("Unknown ability: " + abilityIdentifier.asString());
        }
        return val;
    }

    @NotNull
    public List<IAbility<?>> getAbilitiesFor(String disguiseIdentifier) {
        return this.getAbilitiesFor(disguiseIdentifier, false);
    }

    @NotNull
    public List<IAbility<?>> getAbilitiesFor(String disguiseIdentifier, boolean noFallback) {
        SkillAbilityConfigContainer configuration = (SkillAbilityConfigContainer)this.store.get(disguiseIdentifier);
        if (configuration != null) {
            ObjectArrayList abilities = new ObjectArrayList();
            configuration.getAbilitiyIdentifiers().forEach(arg_0 -> this.lambda$getAbilitiesFor$4((List)abilities, arg_0));
            return abilities;
        }
        if (!noFallback) {
            String[] idSpilt = disguiseIdentifier.split(":", 2);
            if (idSpilt.length < 1) {
                return List.of();
            }
            String idNew = idSpilt[0] + ":@default";
            return this.getAbilitiesFor(idNew, true);
        }
        return List.of();
    }

    private /* synthetic */ void lambda$getAbilitiesFor$4(List abilities, String id) {
        IAbility<?> instance = this.getAbility(NamespacedKey.fromString((String)id));
        if (instance != null) {
            abilities.add(instance);
        }
    }
}

