/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities.options;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;

public class AttributeModifyOption
implements ISkillAbilityOption {
    public static final AttributeModifyOptionHandler OPTION_HANDLER = new AttributeModifyOptionHandler();
    public final List<AttributeInfo> modifiers = new CopyOnWriteArrayList<AttributeInfo>();
    public static final AttributeInfoOptionHandler ATTRIBUTE_INFO_OPTION_HANDLER = new AttributeInfoOptionHandler();

    public AttributeModifyOption(List<AttributeInfo> list) {
        this.modifiers.addAll(list);
    }

    @Override
    public boolean isValid() {
        return this.modifiers.stream().allMatch(AttributeInfo::isValid);
    }

    public static AttributeModifyOption from(Attribute attribute, OperationType operationType, double value) {
        AttributeInfo info = new AttributeInfo(attribute.key().asString(), operationType, value);
        return new AttributeModifyOption(List.of(info));
    }

    public AttributeModifyOption with(Attribute attribute, OperationType operationType, double value) {
        AttributeInfo info = new AttributeInfo(attribute.key().asString(), operationType, value);
        this.modifiers.add(info);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeModifyOption)) {
            return false;
        }
        AttributeModifyOption option = (AttributeModifyOption)obj;
        return this.modifiers.equals(option.modifiers);
    }

    public static class AttributeInfo
    implements ISkillAbilityOption {
        public String attributeName;
        public final OperationType operationType;
        public final double value;

        public AttributeInfo(String name, OperationType type, double value) {
            this.attributeName = name;
            this.operationType = type;
            this.value = value;
        }

        @Override
        public boolean isValid() {
            return !Double.isNaN(this.value) && this.operationType != OperationType.invalid && this.attributeName != null && !this.attributeName.isEmpty() && !this.attributeName.isBlank();
        }

        public String toString() {
            return "AttributeInfo{name=%s, type=%s, value=%s}".formatted(new Object[]{this.attributeName, this.operationType, this.value});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AttributeInfo)) {
                return false;
            }
            AttributeInfo info = (AttributeInfo)obj;
            return this.value == info.value && Objects.equals(this.attributeName, info.attributeName) && this.operationType == info.operationType;
        }
    }

    public static enum OperationType {
        invalid,
        add,
        multiply,
        multiply_base;


        public AttributeModifier.Operation toBukkitOperation() {
            return switch (this.ordinal()) {
                case 1 -> AttributeModifier.Operation.ADD_NUMBER;
                case 2 -> AttributeModifier.Operation.ADD_SCALAR;
                case 3 -> AttributeModifier.Operation.MULTIPLY_SCALAR_1;
                default -> null;
            };
        }
    }

    public static class AttributeModifyOptionHandler
    implements ISkillAbilityOptionHandler<AttributeModifyOption> {
        @Override
        public Class<AttributeModifyOption> getOptionClass() {
            return AttributeModifyOption.class;
        }

        @Override
        public void writeOption(AttributeModifyOption option, @NotNull Map<String, Object> gsonMap) {
            ObjectArrayList attributeInfoOptionList = new ObjectArrayList();
            for (AttributeInfo modifier : option.modifiers) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                ATTRIBUTE_INFO_OPTION_HANDLER.writeOption(modifier, (Map<String, Object>)map);
                attributeInfoOptionList.add(map);
            }
            gsonMap.put("modifiers", attributeInfoOptionList);
        }

        @Override
        @NotNull
        public AttributeModifyOption readOption(@NotNull Map<String, Object> gsonMap) throws ParseErrorException {
            String clazzSimpleName = this.getClass().getSimpleName();
            List rawModifierList = this.utilGetTypedOrThrow("modifiers", gsonMap, List.class);
            ObjectArrayList attributeInfos = new ObjectArrayList();
            for (Object o : rawModifierList) {
                if (!(o instanceof Map)) {
                    throw new ParseErrorException(clazzSimpleName, "Attribute modifiers contain at least one non-map value");
                }
                Map rawMap = (Map)o;
                HashMap converted = new HashMap();
                rawMap.forEach((o1, o2) -> converted.put(o1.toString(), o2));
                ISkillAbilityOption instance = ATTRIBUTE_INFO_OPTION_HANDLER.readOption((Map)converted);
                attributeInfos.add(instance);
            }
            return new AttributeModifyOption((List<AttributeInfo>)attributeInfos);
        }
    }

    public static class AttributeInfoOptionHandler
    implements ISkillAbilityOptionHandler<AttributeInfo> {
        @Override
        public Class<AttributeInfo> getOptionClass() {
            return AttributeInfo.class;
        }

        @Override
        public void writeOption(AttributeInfo option, @NotNull Map<String, Object> gsonMap) {
            gsonMap.put("name", option.attributeName);
            gsonMap.put("type", option.operationType.name().toLowerCase());
            gsonMap.put("value", option.value);
        }

        @Override
        @NotNull
        public AttributeInfo readOption(@NotNull Map<String, Object> gsonMap) throws ParseErrorException {
            String clazzSimpleName = this.getClass().getSimpleName();
            String name = this.utilGetTypedOrThrow("name", gsonMap, String.class);
            String typeName = this.utilGetTypedOrThrow("type", gsonMap, String.class);
            double value = this.utilGetTypedOrThrow("value", gsonMap, Number.class).doubleValue();
            if (!Double.isFinite(value)) {
                throw new ParseErrorException(clazzSimpleName, "Non-Finite attribute value");
            }
            OperationType operationType = (OperationType)((Object)InputHandles.readEnumNonNull((Enum[])OperationType.values(), (String)clazzSimpleName, (String)typeName).orElseThrow(() -> new ParseErrorException(clazzSimpleName, "No value match for operationType '%s'".formatted(typeName))));
            return new AttributeInfo(name, operationType, value);
        }
    }
}

