/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities.options;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;

public class TakesDamageFromWaterOption
implements ISkillAbilityOption {
    public static final TakesDamageFromWaterOptionHandler OPTION_HANDLER = new TakesDamageFromWaterOptionHandler();
    public final double damageAmount;

    public TakesDamageFromWaterOption(double val) {
        this.damageAmount = val;
    }

    @Override
    public boolean isValid() {
        return !Double.isNaN(this.damageAmount);
    }

    public static class TakesDamageFromWaterOptionHandler
    implements ISkillAbilityOptionHandler<TakesDamageFromWaterOption> {
        @Override
        public Class<TakesDamageFromWaterOption> getOptionClass() {
            return TakesDamageFromWaterOption.class;
        }

        @Override
        public boolean acceptNullableOptions() {
            return true;
        }

        @Override
        public void writeOption(TakesDamageFromWaterOption option, @NotNull Map<String, Object> gsonMap) {
            gsonMap.put("damage", option.damageAmount);
        }

        @Override
        public TakesDamageFromWaterOption readOptionNullable(@Nullable Map<String, Object> gsonMap) throws NullPointerException, UnsupportedOperationException, ParseErrorException {
            return gsonMap == null ? new TakesDamageFromWaterOption(1.0) : this.readOption((Map)gsonMap);
        }

        @Override
        @NotNull
        public TakesDamageFromWaterOption readOption(@NotNull Map<String, Object> gsonMap) throws ParseErrorException {
            double damage = this.utilGetTypedOrThrow("damage", gsonMap, Number.class).doubleValue();
            if (!Double.isFinite(damage)) {
                throw new ParseErrorException(this.getClass().getSimpleName(), "Non-Finite value 'damage'");
            }
            return new TakesDamageFromWaterOption(damage);
        }
    }
}

