/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import com.github.retrooper.packetevents.protocol.entity.chicken.ChickenVariant;
import com.github.retrooper.packetevents.protocol.entity.chicken.ChickenVariants;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.AgeableMobWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.ChickenProperties;

public class ChickenWatcher
extends AgeableMobWatcher {
    private final ChickenProperties chickenProperties = DisguiseProperties.INSTANCE.getOrThrow(ChickenProperties.class);

    public ChickenWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.CHICKEN);
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.CHICKEN);
    }

    private ChickenVariant getChickenVariant(String id) {
        return Objects.requireNonNull((ChickenVariant)ChickenVariants.getRegistry().getByName(id), "No chicken variant for id: " + id);
    }

    @Override
    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
        if (Objects.equals(property, this.chickenProperties.VARIANT)) {
            Chicken.Variant variant = (Chicken.Variant)value;
            this.writePersistent(ValueIndex.CHICKEN.CHICKEN_VARIANT, this.getChickenVariant(variant.getKey().asString()));
        }
        super.onPropertyWrite(property, value);
    }

    @Override
    public void writeToCompound(CompoundTag nbt) {
        ChickenVariant variant = this.readOr(ValueIndex.CHICKEN.CHICKEN_VARIANT, null);
        if (variant != null) {
            nbt.putString("variant", variant.getName().toString());
        }
        super.writeToCompound(nbt);
    }
}

