/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import net.minecraft.nbt.CompoundTag;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.entity.CraftTropicalFish;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TropicalFish;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.LivingEntityWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.TropicalFishProperties;

public class TropicalFishWatcher
extends LivingEntityWatcher {
    private volatile DyeColor baseColor = DyeColor.BLACK;
    private volatile DyeColor patternColor = DyeColor.BLACK;
    private volatile TropicalFish.Pattern pattern = TropicalFish.Pattern.BLOCKFISH;

    public TropicalFishWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.TROPICAL_FISH);
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.TROPICAL);
    }

    @Override
    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
        TropicalFishProperties tropicalProperties = DisguiseProperties.INSTANCE.getOrThrow(TropicalFishProperties.class);
        if (property.equals(tropicalProperties.BODY_COLOR)) {
            this.logger.info("WRITE BODY COLOR " + String.valueOf(value));
            this.baseColor = (DyeColor)value;
            this.updatePackedData();
        } else if (property.equals(tropicalProperties.PATTERN_COLOR)) {
            this.patternColor = (DyeColor)value;
            this.updatePackedData();
        } else if (property.equals(tropicalProperties.PATTERN)) {
            this.pattern = (TropicalFish.Pattern)value;
            this.updatePackedData();
        }
        super.onPropertyWrite(property, value);
    }

    private void updatePackedData() {
        int data = CraftTropicalFish.getData((DyeColor)this.patternColor, (DyeColor)this.baseColor, (TropicalFish.Pattern)this.pattern);
        this.writePersistent(ValueIndex.TROPICAL.FISH_VARIANT, data);
    }

    @Override
    public void writeToCompound(CompoundTag nbt) {
        super.writeToCompound(nbt);
        nbt.putInt("Variant", this.read(ValueIndex.TROPICAL.FISH_VARIANT).intValue());
    }
}

