/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import com.github.retrooper.packetevents.protocol.entity.wolfvariant.WolfVariant;
import com.github.retrooper.packetevents.protocol.entity.wolfvariant.WolfVariants;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import org.bukkit.DyeColor;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.TameableAnimalWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntry;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.WolfProperties;
import xyz.nifeather.morph.utilities.Uuids;

public class WolfWatcher
extends TameableAnimalWatcher {
    public WolfWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.WOLF);
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.WOLF);
    }

    private WolfVariant getWolfVariant(String id) {
        return Objects.requireNonNull((WolfVariant)WolfVariants.getRegistry().getByName(id), "No pig variant for id: " + id);
    }

    @Override
    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
        WolfProperties properties = DisguiseProperties.INSTANCE.getOrThrow(WolfProperties.class);
        if (property.equals(properties.VARIANT)) {
            Wolf.Variant val = (Wolf.Variant)value;
            this.writePersistent(ValueIndex.WOLF.WOLF_VARIANT, this.getWolfVariant(val.key().asString()));
        } else if (property.equals(properties.OWNER)) {
            UUID uuid2 = (UUID)value;
            if (Uuids.NIL_UUID.equals(uuid2)) {
                uuid2 = null;
            }
            this.writePersistent(ValueIndex.WOLF.OWNER, Optional.ofNullable(uuid2));
            this.writeTamed(uuid2 != null && !Uuids.NIL_UUID.equals(uuid2));
        } else if (property.equals(properties.COLLAR_COLOR)) {
            DyeColor dyeColor = (DyeColor)value;
            this.writePersistent(ValueIndex.WOLF.COLLAR_COLOR, Integer.valueOf(dyeColor.getWoolData()));
            this.readOr(ValueIndex.CAT.OWNER, Optional.empty()).ifPresentOrElse(uuid -> {}, () -> this.writeProperty(properties.OWNER, UUID.randomUUID()));
        }
        super.onPropertyWrite(property, value);
    }

    @Override
    protected <X> void onEntryWrite(CustomEntry<X> entry, X oldVal, X newVal) {
        super.onEntryWrite(entry, oldVal, newVal);
        if (entry.equals(CustomEntries.ANIMATION)) {
            String animId;
            switch (animId = newVal.toString()) {
                case "sit": {
                    this.writePersistent(ValueIndex.WOLF.TAMEABLE_FLAGS, (byte)1);
                    break;
                }
                case "standup": {
                    this.writePersistent(ValueIndex.WOLF.TAMEABLE_FLAGS, (byte)0);
                }
            }
        }
    }

    @Override
    public void writeToCompound(CompoundTag nbt) {
        super.writeToCompound(nbt);
        nbt.putByte("CollarColor", this.read(ValueIndex.WOLF.COLLAR_COLOR).byteValue());
        nbt.putString("variant", this.read(ValueIndex.WOLF.WOLF_VARIANT).getName().toString());
    }
}

