/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands.subcommands.plugin;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.commands.brigadier.BrigadierCommand;
import xyz.nifeather.morph.messages.CommandStrings;
import xyz.nifeather.morph.messages.HelpStrings;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class QuerySubCommand
extends BrigadierCommand {
    @Resolved
    private MorphManager manager;

    @Override
    public String name() {
        return "query";
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return HelpStrings.queryDescription();
    }

    @Override
    public String getPermissionRequirement() {
        return "feathermorph.query";
    }

    @Override
    public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
        parentBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)this.name()).requires(this::checkPermission)).then(Commands.argument((String)"who", (ArgumentType)ArgumentTypes.players()).executes(this::executes)));
        super.registerAsChild(parentBuilder);
    }

    public int executes(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        List players = (List)((PlayerSelectorArgumentResolver)context.getArgument("who", PlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)context.getSource());
        String locale = null;
        CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            locale = MessageUtils.getLocale(player);
        }
        if (players.isEmpty()) {
            return 0;
        }
        for (Player targetPlayer : players) {
            DisguiseState state = this.manager.getDisguiseStateFor(targetPlayer);
            if (state != null) {
                commandSender.sendMessage(MessageUtils.prefixes(commandSender, CommandStrings.qDisguisedString().withLocale(locale).resolve("who", targetPlayer.getName()).resolve("what", state.getDisguiseIdentifier()).resolve("storage_status", state.showingDisguisedItems() ? CommandStrings.qaShowingDisguisedItemsString() : CommandStrings.qaNotShowingDisguisedItemsString(), null)));
                continue;
            }
            commandSender.sendMessage(MessageUtils.prefixes(commandSender, CommandStrings.qNotDisguisedString().resolve("who", targetPlayer.getName())));
        }
        return 1;
    }
}

