/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands.subcommands.request;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.commands.brigadier.IConvertibleBrigadier;
import xyz.nifeather.morph.interfaces.IManageRequests;
import xyz.nifeather.morph.messages.CommonStrings;
import xyz.nifeather.morph.messages.HelpStrings;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.misc.RequestInfo;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class AcceptSubCommand
extends MorphPluginObject
implements IConvertibleBrigadier {
    @Resolved
    private IManageRequests requests;

    @Override
    public FormattableMessage getHelpMessage() {
        return HelpStrings.requestAcceptDescription();
    }

    @NotNull
    public CompletableFuture<Suggestions> suggests(CommandContext<CommandSourceStack> context, SuggestionsBuilder suggestionsBuilder) {
        CommandSender source = ((CommandSourceStack)context.getSource()).getSender();
        if (!(source instanceof Player)) {
            return CompletableFuture.completedFuture(suggestionsBuilder.build());
        }
        Player player = (Player)source;
        List<RequestInfo> reqs = this.requests.getAvailableRequestsFor(player);
        return CompletableFuture.supplyAsync(() -> {
            reqs.forEach(r -> suggestionsBuilder.suggest(r.sourcePlayer.getName()));
            return suggestionsBuilder.build();
        });
    }

    @Override
    public String name() {
        return "accept";
    }

    public int executes(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        if (!(sender instanceof Player)) {
            return 1;
        }
        Player sourcePlayer = (Player)sender;
        String playerName = StringArgumentType.getString(context, (String)"who");
        Player targetPlayer = Bukkit.getPlayerExact((String)playerName);
        if (targetPlayer == null) {
            sender.sendMessage(MessageUtils.prefixes(sender, CommonStrings.playerNotFoundString()));
            return 1;
        }
        this.requests.acceptRequest(sourcePlayer, targetPlayer);
        return 1;
    }
}

