/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.events;

import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.config.ConfigOption;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.messages.CommandStrings;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.misc.mobs.goal.handles.EntityGoalHandles;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;

public class EntityProcessor
extends MorphPluginObject
implements Listener {
    @Resolved(shouldSolveImmediately=true)
    private MorphConfigManager config;
    private final boolean doModifyAI;

    public boolean currentlyDoModifyAI() {
        return this.doModifyAI;
    }

    public EntityProcessor() {
        this.doModifyAI = this.config.get(Boolean.class, ConfigOption.DO_MODIFY_AI);
        this.config.getBindable(Boolean.class, ConfigOption.DO_MODIFY_AI).onValueChanged((o, n) -> {
            if (this.doModifyAI == n) {
                return;
            }
            this.logger.warn("- x - x - x - x - x - x - x - x - x - x - x - x -");
            this.logger.warn("");
            this.logger.warn("Changes were made about the option of modifying Mobs' AI.");
            this.logger.warn("And this requires a server restart!");
            this.logger.warn("");
            this.logger.warn("- x - x - x - x - x - x - x - x - x - x - x - x -");
            for (Player player : this.featherMorph().getPlatform().onlinePlayersNative()) {
                if (!player.hasPermission("feathermorph.admin")) continue;
                player.sendMessage(MessageUtils.prefixes((CommandSender)player, CommandStrings.aiWarningPrimary()));
                player.sendMessage(MessageUtils.prefixes((CommandSender)player, CommandStrings.aiWarningSecondary()));
            }
        });
    }

    @EventHandler
    public void onEntityAdded(EntityAddToWorldEvent e) {
        if (!this.doModifyAI) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        EntityGoalHandles.instance().handle(mob);
    }
}

