/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.github.retrooper.packetevents.protocol.player.TextureProperty;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class MorphGameProfile
extends GameProfile {
    private String name;
    private UUID uuid;
    private final PropertyMap map = new PropertyMap();

    public MorphGameProfile(@NotNull PlayerProfile profile) {
        super(Objects.requireNonNull(profile.getId(), "Null profile ID!"), Objects.requireNonNull(profile.getName(), "Null profile Name!"));
        this.setUUID(profile.getId());
        this.setName(profile.getName());
        profile.getProperties().forEach(p -> this.map.put((Object)p.getName(), (Object)new Property(p.getName(), p.getValue(), p.getSignature())));
    }

    public MorphGameProfile(GameProfile profile) {
        super(profile.getId(), profile.getName());
        this.setUUID(profile.getId());
        this.setName(profile.getName());
        profile.getProperties().forEach((s, p) -> this.map.put((Object)p.name(), (Object)new Property(p.name(), p.value(), p.signature())));
    }

    public String getName() {
        return this.name != null ? this.name : super.getName();
    }

    public void setName(String str) {
        if (str == null || str.isBlank() || str.isEmpty()) {
            return;
        }
        this.name = str;
    }

    public void setUUID(UUID newuuid) {
        if (newuuid == null) {
            throw new IllegalArgumentException("UUID must not be null!");
        }
        this.uuid = newuuid;
    }

    public UUID getId() {
        return this.uuid != null ? this.uuid : super.getId();
    }

    public PropertyMap getProperties() {
        return this.map;
    }

    public static UserProfile toPacketEventsUserProfile(GameProfile profile) {
        UserProfile userProfile = new UserProfile(profile.getId(), profile.getName());
        ObjectArrayList propertyList = new ObjectArrayList();
        profile.getProperties().forEach((arg_0, arg_1) -> MorphGameProfile.lambda$toPacketEventsUserProfile$2((List)propertyList, arg_0, arg_1));
        userProfile.setTextureProperties((List)propertyList);
        return userProfile;
    }

    private static /* synthetic */ void lambda$toPacketEventsUserProfile$2(List propertyList, String str, Property property) {
        TextureProperty textureProperty = new TextureProperty(property.name(), property.value(), property.signature());
        propertyList.add(textureProperty);
    }
}

