/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MorphParameters {
    public boolean bypassPermission = false;
    public boolean bypassAvailableCheck = false;
    public boolean forceExecute = false;
    public final Player targetPlayer;
    private String targetDisguiseIdentifier;
    @Nullable
    public CommandSender commandSource;
    @Nullable
    public Entity targetedEntity;
    public final Map<String, String> propertiesInput = new ConcurrentHashMap<String, String>();

    public String targetDisguiseIdentifier() {
        return this.targetDisguiseIdentifier;
    }

    public void setDisguiseIdentifier(String id) {
        this.targetDisguiseIdentifier = id;
    }

    public MorphParameters setSource(CommandSender sender) {
        this.commandSource = sender;
        return this;
    }

    public MorphParameters setTargetedEntity(Entity entity) {
        this.targetedEntity = entity;
        return this;
    }

    public MorphParameters setBypassPermission(boolean val) {
        this.bypassPermission = val;
        return this;
    }

    public MorphParameters setBypassAvailableCheck(boolean val) {
        this.bypassAvailableCheck = val;
        return this;
    }

    public MorphParameters setForceExecute(boolean val) {
        this.forceExecute = val;
        return this;
    }

    public MorphParameters withProperties(Map<String, String> map) {
        this.propertiesInput.putAll(map);
        return this;
    }

    public MorphParameters withProperties(@NotNull String key, @NotNull String value) {
        this.propertiesInput.put(key, value);
        return this;
    }

    private MorphParameters(Player targetPlayer, String disguiseID) {
        this.targetPlayer = targetPlayer;
        this.targetDisguiseIdentifier = disguiseID;
    }

    public static MorphParameters create(Player targetPlayer, String disguiseIdentifier) {
        return new MorphParameters(targetPlayer, disguiseIdentifier);
    }
}

