/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.mobs.goal.handles.impl;

import java.util.Collection;
import java.util.Optional;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.RevealingHandler;
import xyz.nifeather.morph.misc.mobs.goal.AvoidPlayerGoals;
import xyz.nifeather.morph.misc.mobs.goal.handles.impl.BasicEntityHandle;
import xyz.nifeather.morph.misc.mobs.goal.impl.MorphDefaultPanickingAvoidPlayerGoal;
import xyz.nifeather.morph.misc.mobs.goal.impl.MorphNearestAttackableGoal;

public class CommonMobHandle
extends BasicEntityHandle<Creature> {
    @Override
    public Optional<Creature> tryCast(Entity entity) {
        Creature creature;
        return Optional.ofNullable(entity instanceof Creature ? (creature = (Creature)entity) : null);
    }

    @Override
    protected Collection<WrappedGoal> filterGoals(Creature mob) {
        return this.goalSelector(mob).getAvailableGoals().stream().filter(wrappedGoal -> wrappedGoal.getGoal() instanceof AvoidEntityGoal).toList();
    }

    @Override
    protected void onTargetGoalFound(Creature creature, WrappedGoal vanillaGoal) {
        boolean isWanderingTrader = creature.getType() == EntityType.WANDERING_TRADER;
        double walkSpeed = isWanderingTrader ? 0.5 : 0.8;
        double sprintSpeed = isWanderingTrader ? 0.5 : 1.33;
        Goal replacingGoal = AvoidPlayerGoals.findGoal(creature, this.morphManager(), this.revealingHandler(), 16.0, walkSpeed, sprintSpeed, this::createDefaultPanickingGoal);
        if (replacingGoal == null) {
            return;
        }
        GoalSelector selector = this.goalSelector(creature);
        selector.addGoal(vanillaGoal.getPriority(), replacingGoal);
        selector.removeGoal((Goal)vanillaGoal);
    }

    private Goal createDefaultPanickingGoal(Creature mob, @NotNull MorphManager morphManager, @NotNull RevealingHandler revealingHandler, double detectDistance, double walkSpeed, double sprintSpeed) {
        return new MorphDefaultPanickingAvoidPlayerGoal(mob, revealingHandler, morphManager, detectDistance, walkSpeed, sprintSpeed);
    }

    @Override
    protected void whenNoTargetGoal(Creature creature) {
        boolean isWanderingTrader = creature.getType() == EntityType.WANDERING_TRADER;
        double walkSpeed = isWanderingTrader ? 0.5 : 0.8;
        double sprintSpeed = isWanderingTrader ? 0.5 : 1.33;
        Goal defaultGoal = AvoidPlayerGoals.findGoal(creature, this.morphManager(), this.revealingHandler(), 16.0, walkSpeed, sprintSpeed);
        if (defaultGoal == null) {
            return;
        }
        this.goalSelector(creature).addGoal(4, defaultGoal);
    }

    @Override
    protected void addDefaultGoals(Creature creature) {
        MorphNearestAttackableGoal goal = new MorphNearestAttackableGoal((Mob)creature, this.morphManager());
        this.goalSelector(creature).addGoal(1, (Goal)goal);
    }
}

