/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.mobs.goal.handles.impl;

import java.util.Collection;
import java.util.Optional;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Ocelot;
import xyz.nifeather.morph.misc.mobs.goal.AvoidPlayerGoals;
import xyz.nifeather.morph.misc.mobs.goal.handles.impl.BasicEntityHandle;
import xyz.nifeather.morph.misc.mobs.goal.impl.MorphNearestAttackableGoal;

public class OcelotHandle
extends BasicEntityHandle<Ocelot> {
    @Override
    public Optional<Ocelot> tryCast(Entity entity) {
        Ocelot ocelot;
        return Optional.ofNullable(entity instanceof Ocelot ? (ocelot = (Ocelot)entity) : null);
    }

    @Override
    protected Collection<WrappedGoal> filterGoals(Ocelot mob) {
        return this.goalSelector(mob).getAvailableGoals().stream().filter(wrappedGoal -> wrappedGoal.getGoal().getClass().getSimpleName().equals("OcelotAvoidEntityGoal")).toList();
    }

    @Override
    protected void onTargetGoalFound(Ocelot ocelot, WrappedGoal vanillaGoal) {
        Goal replacingGoal = AvoidPlayerGoals.findGoal(ocelot, this.morphManager(), this.revealingHandler(), 16.0, 0.8, 1.33);
        if (replacingGoal == null) {
            return;
        }
        GoalSelector selector = this.goalSelector(ocelot);
        selector.addGoal(vanillaGoal.getPriority(), replacingGoal);
        selector.removeGoal((Goal)vanillaGoal);
    }

    @Override
    protected void addDefaultGoals(Ocelot mob) {
        MorphNearestAttackableGoal goal = new MorphNearestAttackableGoal((Mob)mob, this.morphManager());
        this.goalSelector(mob).addGoal(1, (Goal)goal);
    }
}

