/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.waypoint.connection;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTrackedWaypointPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.waypoints.Waypoint;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.NmsRecord;
import xyz.nifeather.morph.misc.waypoint.connection.IMorphRealtimeWaypointConnection;

public class MorphBlockConnection
implements IMorphRealtimeWaypointConnection {
    private final DisguiseState bindingState;
    private final Waypoint.Icon icon;
    private final ServerPlayer receiver;
    private final Player receiverBukkit;
    @NotNull
    private Vec3i lastPosition;

    public MorphBlockConnection(DisguiseState state, Waypoint.Icon icon, ServerPlayer receiver) {
        this.bindingState = state;
        this.icon = icon;
        this.receiver = receiver;
        this.receiverBukkit = receiver.getBukkitEntity();
        this.lastPosition = NmsRecord.ofPlayer(state.getPlayer()).blockPosition();
    }

    public void connect() {
        UUID uuid = this.bindingState.getDisguiseWrapper().getVirtualEntityUUID();
        this.receiver.connection.send((Packet)ClientboundTrackedWaypointPacket.addWaypointPosition((UUID)uuid, (Waypoint.Icon)this.icon, (Vec3i)this.lastPosition));
    }

    public void disconnect() {
        UUID uuid = this.bindingState.getDisguiseWrapper().getVirtualEntityUUID();
        this.receiver.connection.send((Packet)ClientboundTrackedWaypointPacket.removeWaypoint((UUID)uuid));
    }

    @Override
    public void internalUpdate() {
        ServerPlayer source = NmsRecord.ofPlayer(this.bindingState.getPlayer());
        BlockPos blockPos = source.blockPosition();
        if (blockPos.distManhattan(this.lastPosition) <= 0) {
            return;
        }
        UUID uuid = this.bindingState.getDisguiseWrapper().getVirtualEntityUUID();
        this.receiver.connection.send((Packet)ClientboundTrackedWaypointPacket.updateWaypointPosition((UUID)uuid, (Waypoint.Icon)this.icon, (Vec3i)blockPos));
        this.lastPosition = blockPos;
    }

    public void update() {
        this.internalUpdate();
    }

    public boolean isBroken() {
        ServerPlayer player = NmsRecord.ofPlayer(this.bindingState.getPlayer());
        return !this.bindingState.getPlayer().isTrackedBy(this.receiverBukkit) || !WaypointTransmitter.isChunkVisible((ChunkPos)player.chunkPosition(), (ServerPlayer)this.receiver);
    }
}

