/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.commands.C2S;

import java.util.Map;
import xyz.nifeather.morph.network.BasicClientHandler;
import xyz.nifeather.morph.network.annotations.Environment;
import xyz.nifeather.morph.network.annotations.EnvironmentType;
import xyz.nifeather.morph.network.commands.C2S.AbstractC2SCommand;
import xyz.nifeather.morph.network.utils.Asserts;

public class C2SToggleSelfCommand
extends AbstractC2SCommand<SelfViewMode> {
    private final SelfViewMode selfViewMode;

    public C2SToggleSelfCommand(SelfViewMode val) {
        this.selfViewMode = val;
    }

    public SelfViewMode getSelfViewMode() {
        return this.selfViewMode;
    }

    public static C2SToggleSelfCommand fromArguments(Map<String, String> arguments) throws RuntimeException {
        return new C2SToggleSelfCommand(SelfViewMode.fromNetworkname(Asserts.getStringOrThrow(arguments, "mode")));
    }

    @Override
    public Map<String, String> generateArgumentMap() {
        return Map.of("mode", this.selfViewMode.networkName);
    }

    @Override
    public String getBaseName() {
        return "set_selfview_mode";
    }

    @Override
    @Environment(value=EnvironmentType.SERVER)
    public void onCommand(BasicClientHandler<?> listener) {
        listener.onToggleSelfCommand(this);
    }

    public static enum SelfViewMode {
        ON("true"),
        OFF("false"),
        CLIENT_ON("client true"),
        CLIENT_OFF("client false");

        private final String networkName;

        public static SelfViewMode fromBoolean(boolean value) {
            return value ? ON : OFF;
        }

        public static SelfViewMode fromNetworkname(String str) throws RuntimeException {
            if (str.equalsIgnoreCase("true")) {
                return ON;
            }
            if (str.equalsIgnoreCase("false")) {
                return OFF;
            }
            if (str.equalsIgnoreCase("client true")) {
                return CLIENT_ON;
            }
            if (str.equalsIgnoreCase("client false")) {
                return CLIENT_OFF;
            }
            throw new RuntimeException("No matched SelfViewMode for input '%s'".formatted(str));
        }

        private SelfViewMode(String networkName) {
            this.networkName = networkName;
        }

        public String toString() {
            return this.networkName;
        }
    }
}

