/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.skills.impl;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.api.morphs.skills.SkillNames;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.NmsRecord;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetAggressiveCommand;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.skills.impl.DelayedMorphSkill;
import xyz.nifeather.morph.skills.options.NoOpConfiguration;
import xyz.nifeather.morph.utilities.DamageSourceUtils;

public class SonicBoomMorphSkill
extends DelayedMorphSkill<NoOpConfiguration> {
    public static int defaultCooldown = 94;
    @Resolved
    private MorphClientHandler clientHandler;

    @Override
    public ISkillAbilityOptionHandler<NoOpConfiguration> optionHandler() {
        return NoOpConfiguration.OPTION_HANDLER;
    }

    @Override
    protected DelayedMorphSkill.ExecuteResult preExecute(Player player, DisguiseState state, @NotNull NoOpConfiguration option) {
        this.playSoundToNearbyPlayers(player, 160, Key.key((String)"minecraft", (String)"entity.warden.sonic_charge"), Sound.Source.HOSTILE);
        state.getDisguiseWrapper().setAggressive(true);
        this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetAggressiveCommand(true));
        return DelayedMorphSkill.ExecuteResult.success(0);
    }

    @Override
    protected int getExecuteDelay(NoOpConfiguration option) {
        return 34;
    }

    @Override
    protected void executeDelayedSkill(Player player, DisguiseState state, NoOpConfiguration option) {
        Entity entity;
        state.getDisguiseWrapper().setAggressive(false);
        this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetAggressiveCommand(false));
        Vector location = player.getEyeLocation().toVector();
        Vector direction = player.getEyeLocation().getDirection();
        int maxDistance = 15;
        World world = player.getWorld();
        RayTraceResult traceResult = player.rayTraceEntities(maxDistance, true);
        CraftLivingEntity entity2 = null;
        if (traceResult != null && traceResult.getHitEntity() != null && (entity = traceResult.getHitEntity()) instanceof CraftLivingEntity) {
            CraftLivingEntity living;
            entity2 = living = (CraftLivingEntity)entity;
        }
        this.playSoundToNearbyPlayers(player, 160, Key.key((String)"minecraft", (String)"entity.warden.sonic_boom"), Sound.Source.HOSTILE);
        for (int i = 1; i < maxDistance; ++i) {
            Vector locNew = location.clone().add(direction.clone().multiply(i));
            if (entity2 != null && entity2.getLocation().distance(player.getLocation()) <= (double)i) {
                NmsRecord record = NmsRecord.of(player, (Entity)entity2);
                ServerPlayer nmsPlayer = record.nmsPlayer();
                net.minecraft.world.entity.LivingEntity nmsEntity = NmsRecord.ofLiving((LivingEntity)entity2);
                DamageSources sources = record.nmsWorld().damageSources();
                nmsEntity.hurtServer(record.nmsWorld(), (DamageSource)DamageSourceUtils.toNotScalable(sources.sonicBoom((net.minecraft.world.entity.Entity)nmsPlayer)), 10.0f);
                double d = 0.5 * (1.0 - nmsEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                double e = 2.5 * (1.0 - nmsEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                nmsEntity.push(direction.getX() * e, direction.getY() * d, direction.getZ() * e, (net.minecraft.world.entity.Entity)nmsPlayer);
            }
            world.spawnParticle(Particle.SONIC_BOOM, locNew.getX(), locNew.getY(), locNew.getZ(), 1, null);
        }
    }

    @Override
    @NotNull
    public NamespacedKey getIdentifier() {
        return SkillNames.SONIC_BOOM;
    }
}

