/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.skills.options;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;

public class EffectConfiguration
implements ISkillAbilityOption {
    public static final ApplyEffectSkillConfigurationHandler OPTION_HANDLER = new ApplyEffectSkillConfigurationHandler();
    private final String name;
    private final int multiplier;
    private final int duration;
    private final boolean acquiresWater;
    private final boolean showGuardian;
    @Nullable
    private final String soundName;
    private final int soundDistance;
    private final int applyDistance;

    public EffectConfiguration(String name, int multiplier, int duration, boolean requiresWater, boolean showGuardian, @Nullable String soundName, int soundDistance, int applyDistance) {
        this.name = name;
        this.multiplier = multiplier;
        this.duration = duration;
        this.acquiresWater = requiresWater;
        this.showGuardian = showGuardian;
        this.soundName = soundName;
        this.soundDistance = soundDistance;
        this.applyDistance = applyDistance;
    }

    public String getName() {
        return this.name;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean acquiresWater() {
        return this.acquiresWater;
    }

    public boolean showGuardian() {
        return this.showGuardian;
    }

    @NotNull
    public String getSoundName() {
        return this.soundName == null ? "" : this.soundName;
    }

    public int getApplyDistance() {
        return this.applyDistance;
    }

    public int getSoundDistance() {
        return this.soundDistance;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public static class ApplyEffectSkillConfigurationHandler
    implements ISkillAbilityOptionHandler<EffectConfiguration> {
        @Override
        public Class<EffectConfiguration> getOptionClass() {
            return EffectConfiguration.class;
        }

        @Override
        public void writeOption(EffectConfiguration option, @NotNull Map<String, Object> gsonMap) {
            gsonMap.put("name", option.getName());
            gsonMap.put("multiplier", option.getMultiplier());
            gsonMap.put("duration", option.getDuration());
            gsonMap.put("acquires_water", option.acquiresWater());
            gsonMap.put("show_guardian", option.showGuardian());
            gsonMap.put("sound", option.getSoundName());
            gsonMap.put("sound_distance", option.getSoundDistance());
            gsonMap.put("apply_distance", option.getApplyDistance());
        }

        @Override
        @NotNull
        public EffectConfiguration readOption(@NotNull Map<String, Object> gsonMap) throws ParseErrorException {
            String name = this.utilGetTypedOrThrow("name", gsonMap, String.class);
            int multiplier = this.utilGetTypedOrThrow("multiplier", gsonMap, Number.class).intValue();
            int duration = this.utilGetTypedOrThrow("duration", gsonMap, Number.class).intValue();
            boolean acquiresWater = this.utilGetTypedOrThrow("acquires_water", gsonMap, Boolean.class);
            boolean showGuardian = this.utilGetTypedOrThrow("show_guardian", gsonMap, Boolean.class);
            String soundName = this.utilGetTypedOrNull("sound", gsonMap, String.class);
            int soundDistance = this.utilGetTypedOrThrow("sound_distance", gsonMap, Number.class).intValue();
            int applyDistance = this.utilGetTypedOrThrow("apply_distance", gsonMap, Number.class).intValue();
            return new EffectConfiguration(name, multiplier, duration, acquiresWater, showGuardian, soundName, soundDistance, applyDistance);
        }
    }
}

