/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.storage.skill;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.abilities.impl.AttributeModifyingAbility;
import xyz.nifeather.morph.abilities.options.AttributeModifyOption;
import xyz.nifeather.morph.abilities.options.ExtraAirOption;
import xyz.nifeather.morph.abilities.options.PotionEffectOption;
import xyz.nifeather.morph.abilities.options.ReduceDamageOption;
import xyz.nifeather.morph.api.morphs.abilities.AbilityNames;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.skills.DefaultConfigGenerator;
import xyz.nifeather.morph.storage.DirectoryJsonBasedStorage;
import xyz.nifeather.morph.storage.MorphJsonBasedStorage;
import xyz.nifeather.morph.storage.skill.SkillAbilityConfigContainer;
import xyz.nifeather.morph.storage.skill.SkillAbilityConfigurationContainer;

public class SkillsConfigurationStoreNew
extends DirectoryJsonBasedStorage<SkillAbilityConfigContainer> {
    private static final int TARGET_PACKAGE_VERSION = 8;
    private static final SkillAbilityConfigContainer defaultConfig = new SkillAbilityConfigContainer();

    public SkillsConfigurationStoreNew() {
        super("skills");
    }

    @Initializer
    private void load() {
        int packageVersion = this.getPackageVersion();
        if (packageVersion < 8) {
            this.update(packageVersion);
        }
        if (packageVersion > 8) {
            this.logger.warn("The package version is newer than our implementation! Errors may occur!");
        }
    }

    private void update(int currentVersion) {
        if (currentVersion < 1) {
            File legacySkillFile = new File(this.plugin.getDataFolder(), "skills.json");
            if (legacySkillFile.exists()) {
                this.migrateFromLegacyStorage();
            } else {
                this.saveDefaultGeneratedConfigurations();
                return;
            }
        }
        if (currentVersion < 2) {
            this.migrateAttribute();
        }
        if (currentVersion < 3) {
            this.migrateWitherSkeleton();
        }
        if (currentVersion < 4) {
            this.logger.info("Migrating attribute name again, to fix windows migrate issue.");
            this.migrateAttribute();
        }
        Map<String, SkillAbilityConfigContainer> generatedConfigurations = DefaultConfigGenerator.createInstance().generateConfiguration();
        if (currentVersion < 5) {
            this.saveEntityTypeConfiguration(generatedConfigurations, EntityType.HAPPY_GHAST);
        }
        if (currentVersion < 6) {
            this.saveEntityTypeConfiguration(generatedConfigurations, EntityType.GUARDIAN);
        }
        if (currentVersion < 7) {
            this.migrateMaxAirOption(EntityType.AXOLOTL, 6000);
            this.migrateMaxAirOption(EntityType.DOLPHIN, 4800);
        }
        if (currentVersion < 8) {
            this.migratePotionEffect();
        }
        this.setPackageVersion(8);
    }

    private void migratePotionEffect() {
        File[] files;
        for (File file : files = this.directoryStorage.getFiles(".*\\.json$")) {
            SkillAbilityConfigContainer config = (SkillAbilityConfigContainer)this.loadFrom(file);
            if (config == null) {
                this.logger.warn("Can't load SkillAbilityConfiguration from '%s', see errors above.".formatted(file.toString()));
                continue;
            }
            String key = this.getKeyFromFile(file);
            if (key == null) {
                this.logger.warn("Can't get mob key from '%s', see errors above.".formatted(file.toString()));
                continue;
            }
            if (!config.getAbilitiyIdentifiers().contains(AbilityNames.POTION_ON_ATTACK.asString())) continue;
            config.legacy_MobID = key;
            this.logger.info("Migrating " + key);
            try {
                PotionEffectOption option = config.readOptions(AbilityNames.POTION_ON_ATTACK, PotionEffectOption.LEGACY_OPTION_HANDLER);
                config.setOption(AbilityNames.POTION_ON_ATTACK, PotionEffectOption.OPTION_HANDLER, option);
                this.save(config);
                this.logger.info("Done saving new potion id for {}", (Object)file.getName());
            }
            catch (NullPointerException | ParseErrorException e) {
                this.logger.error("Unable to read legacy potion option, ignoring...", (Throwable)e);
            }
        }
    }

    private void migrateMaxAirOption(EntityType type, int air) {
        this.logger.info("Migrating %s configuration...".formatted(type));
        SkillAbilityConfigContainer configuration = (SkillAbilityConfigContainer)this.get(type.key().asString());
        if (configuration == null) {
            this.logger.info("No configuration present, skipping...");
            return;
        }
        configuration.addAbility(AbilityNames.EXTRA_AIR).appendOption(AbilityNames.EXTRA_AIR, ExtraAirOption.OPTION_HANDLER, new ExtraAirOption(air));
        configuration.legacy_MobID = type.key().asString();
        this.save(configuration);
        this.logger.info("Done Migrating new %s configuration".formatted(type));
    }

    private void saveEntityTypeConfiguration(Map<String, SkillAbilityConfigContainer> defaultConfigurations, EntityType entityType) {
        SkillAbilityConfigContainer newConfig = defaultConfigurations.getOrDefault(entityType.key().asString(), null);
        if (newConfig == null) {
            return;
        }
        newConfig.legacy_MobID = entityType.key().asString();
        this.save(newConfig);
    }

    private void migrateAttribute() {
        this.logger.info("Starting migration of attribute names...");
        File[] files = this.directoryStorage.getFiles(".*\\.json$");
        AttributeModifyingAbility abilityInstance = new AttributeModifyingAbility();
        for (File file : files) {
            AttributeModifyOption option;
            SkillAbilityConfigContainer config = (SkillAbilityConfigContainer)this.loadFrom(file);
            if (config == null) {
                this.logger.warn("Can't load SkillAbilityConfiguration from '%s', see errors above.".formatted(file.toString()));
                continue;
            }
            try {
                option = config.getAbilitiyIdentifiers().contains(abilityInstance.getIdentifier().asString()) ? config.readOptions(abilityInstance) : null;
            }
            catch (NullPointerException | ParseErrorException e) {
                this.logger.error("Can't read ability option from file! Skipping {}", (Object)file.getName(), (Object)e);
                continue;
            }
            if (option == null) continue;
            String key = this.getKeyFromFile(file);
            if (key == null) {
                this.logger.warn("Can't get mob key from '%s', see errors above.".formatted(file.toString()));
                continue;
            }
            config.legacy_MobID = key;
            this.logger.info("Migrating " + key);
            for (AttributeModifyOption.AttributeInfo attributeInfo : option.modifiers) {
                if (!attributeInfo.isValid()) {
                    this.logger.warn("Invalid attribute info for '%s > %s'! Ignoring...".formatted(config.legacy_MobID, attributeInfo.attributeName == null ? "<unknown attribute name>" : attributeInfo.attributeName));
                    continue;
                }
                attributeInfo.attributeName = attributeInfo.attributeName.replace("generic.", "");
            }
            config.appendOption(abilityInstance.getIdentifier(), abilityInstance.optionHandler(), option);
            this.save(config);
        }
        this.logger.info("Done.");
    }

    private void migrateFromLegacyStorage() {
        try {
            this.logger.info("Migrating from legacy skill configuration...");
            LegacyReadonlyConfigurationStorage storage = new LegacyReadonlyConfigurationStorage();
            storage.initializeStorage();
            File file = storage.file();
            SkillAbilityConfigurationContainer storing = storage.getStoring();
            if (storing == null) {
                this.logger.warn("Can't migrate from legacy skill configuration: Null storing object, is everything all right?");
                return;
            }
            storing.configurations.forEach(this::save);
            boolean success = file.renameTo(new File(file.getParent(), "skills.json.old"));
            if (!success) {
                this.logger.info("Can't rename 'skills.json' to 'skills.json.old', but it's not a big deal, I guess...");
            }
            this.logger.info("Done migrating legacy skill configuration!");
        }
        catch (Throwable t) {
            this.logger.warn("Can't migrate from legacy skill configuration", t);
        }
    }

    private void migrateWitherSkeleton() {
        this.logger.info("Migrating new Wither Skeleton configuration");
        SkillAbilityConfigContainer configuration = (SkillAbilityConfigContainer)this.get(EntityType.WITHER_SKELETON.key().asString());
        if (configuration == null) {
            this.logger.info("No configuration present for minecraft:wither_skeleton, skipping...");
            return;
        }
        configuration.addAbility(AbilityNames.HAS_FIRE_RESISTANCE).addAbility(AbilityNames.REDUCES_WITHER_DAMAGE).appendOption(AbilityNames.REDUCES_WITHER_DAMAGE, ReduceDamageOption.OPTION_HANDLER, new ReduceDamageOption(1.0, true));
        configuration.legacy_MobID = EntityType.WITHER_SKELETON.key().asString();
        this.save(configuration);
        this.logger.info("Done Migrating new Wither Skeleton configuration");
    }

    private void saveDefaultGeneratedConfigurations() {
        this.logger.info("Saving default generated skill configurations...");
        Map<String, SkillAbilityConfigContainer> generatedConfiguration = DefaultConfigGenerator.createInstance().generateConfiguration();
        generatedConfiguration.forEach((id, config) -> {
            config.legacy_MobID = id;
            this.save((SkillAbilityConfigContainer)config);
        });
        this.logger.info("Done saving default generated skill configurations!");
    }

    public void save(SkillAbilityConfigContainer configuration) {
        String identifier = configuration.legacy_MobID;
        if (identifier == null) {
            this.logger.warn("Found a configuration from legacy store that doesn't have a mobId! Ignoring...");
            return;
        }
        String path = this.getPath(identifier) + ".json";
        File file = this.directoryStorage.getFile(path, true);
        if (file == null) {
            this.logger.warn("Cannot save disguise configuration for " + identifier);
            return;
        }
        String json = this.gson.toJson((Object)configuration);
        try {
            FileUtils.writeStringToFile((File)file, (String)json, (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable t) {
            this.logger.error("Can't write content to file", t);
        }
    }

    @Override
    protected SkillAbilityConfigContainer getDefault() {
        return defaultConfig;
    }

    public static class PackageVersions {
        public static final int INITIAL = 1;
        public static final int ATTRIBUTE_NAME_CHANGED = 2;
        public static final int WITHER_SKELETON_CHANGES = 3;
        public static final int MERGE_ATTRIBUTE_AGAIN = 4;
        public static final int HAPPY_GHAST = 5;
        public static final int GUARDIAN_SKILL = 6;
        public static final int EXTRA_AIR_ABILITY = 7;
        public static final int POTION_MIGRATE = 8;
    }

    private static class LegacyReadonlyConfigurationStorage
    extends MorphJsonBasedStorage<SkillAbilityConfigurationContainer> {
        private LegacyReadonlyConfigurationStorage() {
        }

        @Override
        @NotNull
        protected String getFileName() {
            return "skills.json";
        }

        public File file() {
            return this.configurationFile;
        }

        @Nullable
        public SkillAbilityConfigurationContainer getStoring() {
            return (SkillAbilityConfigurationContainer)this.storingObject;
        }

        @Override
        @NotNull
        protected SkillAbilityConfigurationContainer createDefault() {
            return new SkillAbilityConfigurationContainer();
        }

        @Override
        @NotNull
        protected String getDisplayName() {
            return "Legacy skill configuration store";
        }
    }
}

