/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.utilities;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.player.Player;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Enemy;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.misc.DisguiseTypes;

public class EntityTypeUtils {
    private static final Map<EntityType, Class<? extends Entity>> nmsClassMap = new Object2ObjectOpenHashMap();
    private static final Map<EntityType, net.minecraft.world.entity.EntityType<?>> nmsTypeMap;

    @Nullable
    public static EntityType fromString(String key, boolean nullWhenUnknown) {
        EntityType val = EntityTypeUtils.fromString(key);
        return val == EntityType.UNKNOWN ? null : val;
    }

    public static EntityType fromString(String key) {
        if (key.startsWith(DisguiseTypes.PLAYER.getNameSpace() + ":")) {
            return EntityType.PLAYER;
        }
        return Arrays.stream(EntityType.values()).filter(t -> !t.equals((Object)EntityType.UNKNOWN) && t.getKey().asString().equals(key)).findFirst().orElse(EntityType.UNKNOWN);
    }

    @Nullable
    public static <T extends Entity> T createEntityThenDispose(net.minecraft.world.entity.EntityType<T> nmsType, World world, Location spawnLocation) {
        spawnLocation = spawnLocation.clone();
        ServerLevel serverWorld = ((CraftWorld)world).getHandle();
        spawnLocation.setY(-4096.0);
        Location locationBlock = spawnLocation.toBlockLocation();
        BlockPos spawnBlockLocation = new BlockPos(locationBlock.getBlockX(), locationBlock.getBlockY(), locationBlock.getBlockZ());
        return (T)nmsType.create(serverWorld, EntityTypeUtils::scheduleEntityDiscard, spawnBlockLocation, EntitySpawnReason.COMMAND, false, false);
    }

    @Nullable
    public static net.minecraft.world.entity.EntityType<?> getNmsType(@NotNull EntityType bukkitType) {
        net.minecraft.world.entity.EntityType<?> cachedResult = nmsTypeMap.get(bukkitType);
        if (cachedResult != null) {
            return cachedResult;
        }
        if (bukkitType == EntityType.UNKNOWN) {
            return null;
        }
        net.minecraft.world.entity.EntityType result = net.minecraft.world.entity.EntityType.byString((String)bukkitType.key().asString()).orElse(null);
        nmsTypeMap.put(bukkitType, result);
        return result;
    }

    @Nullable
    public static Class<? extends Entity> getNmsClass(@NotNull EntityType type, World tickingWorld, Location tickingLocation) {
        Class cache = nmsClassMap.getOrDefault(type, null);
        if (cache != null) {
            return cache;
        }
        net.minecraft.world.entity.EntityType nmsType = net.minecraft.world.entity.EntityType.byString((String)type.key().asString()).orElse(null);
        if (nmsType == null) {
            nmsClassMap.put(type, null);
            return null;
        }
        Object entity = EntityTypeUtils.createEntityThenDispose(nmsType, tickingWorld, tickingLocation);
        if (entity == null) {
            nmsClassMap.put(type, null);
            return null;
        }
        nmsClassMap.put(type, entity.getClass());
        return entity.getClass();
    }

    private static void scheduleEntityDiscard(Entity nmsEntity) {
        CraftEntity entity = nmsEntity.getBukkitEntity();
        entity.getScheduler().run((Plugin)FeatherMorphMain.getInstance(), retiredTask -> {}, () -> ((CraftEntity)entity).remove());
    }

    public static boolean hasBabyVariant(EntityType type) {
        return switch (type) {
            case EntityType.COW, EntityType.SHEEP, EntityType.BEE, EntityType.CAMEL, EntityType.CAT, EntityType.CHICKEN, EntityType.DONKEY, EntityType.FOX, EntityType.GOAT, EntityType.HORSE, EntityType.LLAMA, EntityType.MOOSHROOM, EntityType.MULE, EntityType.TRADER_LLAMA, EntityType.VILLAGER, EntityType.OCELOT, EntityType.PANDA, EntityType.PIG, EntityType.POLAR_BEAR, EntityType.RABBIT, EntityType.SNIFFER, EntityType.TURTLE, EntityType.WOLF, EntityType.HOGLIN, EntityType.ZOMBIE, EntityType.ZOMBIE_VILLAGER, EntityType.PIGLIN, EntityType.HUSK, EntityType.DROWNED, EntityType.ZOMBIFIED_PIGLIN, EntityType.STRIDER, EntityType.SKELETON_HORSE, EntityType.ZOMBIE_HORSE, EntityType.ZOGLIN -> true;
            default -> false;
        };
    }

    public static boolean isZombie(EntityType type) {
        return type == EntityType.ZOMBIE || type == EntityType.ZOMBIE_VILLAGER || type == EntityType.DROWNED || type == EntityType.HUSK;
    }

    public static boolean isSkeleton(EntityType type) {
        return type == EntityType.SKELETON || type == EntityType.STRAY || type == EntityType.WITHER_SKELETON || type == EntityType.BOGGED;
    }

    public static boolean isZombiesHostile(EntityType type) {
        return EntityTypeUtils.isGolem(type) || type == EntityType.VILLAGER || type == EntityType.WANDERING_TRADER || type == EntityType.PLAYER;
    }

    public static boolean isGolem(EntityType type) {
        return type == EntityType.IRON_GOLEM || type == EntityType.SNOW_GOLEM;
    }

    public static boolean isBruteHostile(EntityType type) {
        return EntityTypeUtils.isGolem(type) || type == EntityType.WITHER_SKELETON || type == EntityType.PLAYER;
    }

    public static boolean isPiglinHostile(EntityType type) {
        return type == EntityType.WITHER || type == EntityType.WITHER_SKELETON || type == EntityType.PLAYER;
    }

    public static boolean isGuardianHostile(EntityType type) {
        return type == EntityType.PLAYER || type == EntityType.AXOLOTL || type == EntityType.SQUID || type == EntityType.GLOW_SQUID;
    }

    public static boolean isWitherSkeletonHostile(EntityType type) {
        return type == EntityType.PLAYER || type == EntityType.PIGLIN || type == EntityType.PIGLIN_BRUTE || EntityTypeUtils.isGolem(type);
    }

    public static boolean isZoglinHostile(EntityType type) {
        return type != EntityType.CREEPER && type != EntityType.GHAST && type != EntityType.ZOGLIN;
    }

    public static boolean isWitherHostile(EntityType type) {
        return type == EntityType.ZOMBIE || type == EntityType.ZOMBIE_VILLAGER || type == EntityType.DROWNED || type == EntityType.HUSK || type == EntityType.SKELETON || type == EntityType.WITHER_SKELETON || type == EntityType.STRAY || type == EntityType.SKELETON_HORSE || type == EntityType.ZOMBIE_HORSE || type == EntityType.PHANTOM || type == EntityType.ZOMBIFIED_PIGLIN || type == EntityType.WITHER || type == EntityType.GHAST;
    }

    public static boolean isRaiderHostile(EntityType type) {
        return type == EntityType.PLAYER || type == EntityType.VILLAGER || type == EntityType.WANDERING_TRADER || EntityTypeUtils.isGolem(type);
    }

    public static Set<EntityType> wardenLessAware() {
        return ObjectSet.of((Object)EntityType.ARMOR_STAND, (Object)EntityType.WARDEN);
    }

    public static Set<EntityType> canFly() {
        return ObjectSet.of((Object[])new EntityType[]{EntityType.ALLAY, EntityType.ENDER_DRAGON, EntityType.BAT, EntityType.BEE, EntityType.BLAZE, EntityType.GHAST, EntityType.VEX, EntityType.PHANTOM, EntityType.WITHER, EntityType.PARROT});
    }

    public static Set<EntityType> hasFireResistance() {
        return ObjectSet.of((Object[])new EntityType[]{EntityType.MAGMA_CUBE, EntityType.BLAZE, EntityType.WITHER_SKELETON, EntityType.WITHER, EntityType.STRIDER, EntityType.ZOMBIFIED_PIGLIN, EntityType.GHAST, EntityType.WARDEN, EntityType.ENDER_DRAGON, EntityType.ZOGLIN});
    }

    public static Set<EntityType> takesDamageFromWater() {
        return ObjectSet.of((Object[])new EntityType[]{EntityType.ENDERMAN, EntityType.BLAZE, EntityType.SNOW_GOLEM, EntityType.STRIDER});
    }

    public static Set<EntityType> canBreatheUnderWater() {
        return ObjectSet.of((Object[])new EntityType[]{EntityType.COD, EntityType.SALMON, EntityType.PUFFERFISH, EntityType.TROPICAL_FISH, EntityType.SQUID, EntityType.GLOW_SQUID, EntityType.AXOLOTL, EntityType.GUARDIAN, EntityType.ELDER_GUARDIAN, EntityType.DOLPHIN, EntityType.TADPOLE, EntityType.DROWNED});
    }

    public static Set<EntityType> dryOutInAir() {
        return ObjectSet.of((Object[])new EntityType[]{EntityType.COD, EntityType.SALMON, EntityType.PUFFERFISH, EntityType.TROPICAL_FISH, EntityType.SQUID, EntityType.GLOW_SQUID, EntityType.AXOLOTL, EntityType.GUARDIAN, EntityType.ELDER_GUARDIAN, EntityType.DOLPHIN, EntityType.TADPOLE});
    }

    public static Set<EntityType> burnsUnderSun() {
        return ObjectSet.of((Object[])new EntityType[]{EntityType.ZOMBIE, EntityType.ZOMBIE_VILLAGER, EntityType.SKELETON, EntityType.STRAY, EntityType.DROWNED, EntityType.PHANTOM});
    }

    public static Set<EntityType> spider() {
        return ObjectSet.of((Object)EntityType.SPIDER, (Object)EntityType.CAVE_SPIDER);
    }

    public static Set<EntityType> alwaysNightVision() {
        return ObjectSet.of((Object)EntityType.BAT, (Object)EntityType.ENDERMAN);
    }

    public static Set<EntityType> hasJumpBoost() {
        return Set.of(EntityType.MAGMA_CUBE);
    }

    public static Set<EntityType> hasSmallJumpBoost() {
        return Set.of(EntityType.RABBIT);
    }

    public static EntityType hasSpeedBoost() {
        return EntityType.HORSE;
    }

    public static Set<EntityType> noFallDamage() {
        return ObjectSet.of((Object[])new EntityType[]{EntityType.IRON_GOLEM, EntityType.CAT, EntityType.OCELOT, EntityType.SNOW_GOLEM, EntityType.MAGMA_CUBE, EntityType.CHICKEN, EntityType.SHULKER});
    }

    public static Set<EntityType> noFallDamage1() {
        return ObjectSet.of((Object[])new EntityType[]{EntityType.BAT, EntityType.BLAZE, EntityType.ENDER_DRAGON, EntityType.GHAST, EntityType.PARROT, EntityType.VEX, EntityType.WITHER});
    }

    public static EntityType reducesMagicDamage() {
        return EntityType.WITCH;
    }

    public static EntityType reducesFallDamage() {
        return EntityType.GOAT;
    }

    public static Set<EntityType> hasFeatherFalling() {
        return Set.of(EntityType.CHICKEN);
    }

    public static EntityType hasSnowTrail() {
        return EntityType.SNOW_GOLEM;
    }

    public static boolean saddleable(EntityType type) {
        return type == EntityType.HORSE || type == EntityType.MULE || type == EntityType.DONKEY || type == EntityType.CAMEL || type == EntityType.SKELETON_HORSE || type == EntityType.ZOMBIE_HORSE;
    }

    public static boolean hasBossBar(EntityType type) {
        return type == EntityType.ENDER_DRAGON || type == EntityType.WITHER;
    }

    public static float getDefaultFlyingSpeed(@Nullable EntityType type) {
        if (type == null) {
            return 0.1f;
        }
        return switch (type) {
            case EntityType.BEE, EntityType.ALLAY, EntityType.BLAZE, EntityType.VEX, EntityType.BAT, EntityType.PARROT -> 0.05f;
            case EntityType.GHAST, EntityType.PHANTOM -> 0.06f;
            case EntityType.ENDER_DRAGON -> 0.15f;
            default -> 0.1f;
        };
    }

    @Deprecated
    @Nullable
    public static String getStepSound(EntityType type) {
        if (type == EntityType.PLAYER) {
            return null;
        }
        return "entity.%s.step".formatted(type.getKey().getKey());
    }

    @Nullable
    public static String getDamageSoundKey(EntityType type) {
        if (type == EntityType.PLAYER) {
            return null;
        }
        if (type == EntityType.ARMOR_STAND) {
            return "entity.armor_stand.hit";
        }
        if (type == EntityType.TRADER_LLAMA) {
            return "entity.llama.hurt";
        }
        return "entity.%s.hurt".formatted(type.getKey().getKey());
    }

    public static boolean isEnemy(EntityType type) {
        if (type == EntityType.PLAYER) {
            return false;
        }
        if (type.getEntityClass() == null) {
            return false;
        }
        return Enemy.class.isAssignableFrom(type.getEntityClass());
    }

    public static boolean panicsFrom(EntityType sourceType, EntityType targetType) {
        return switch (sourceType) {
            case EntityType.CREEPER -> {
                if (targetType == EntityType.CAT || targetType == EntityType.OCELOT) {
                    yield true;
                }
                yield false;
            }
            case EntityType.PHANTOM -> {
                if (targetType == EntityType.CAT) {
                    yield true;
                }
                yield false;
            }
            case EntityType.SPIDER -> {
                if (targetType == EntityType.ARMADILLO) {
                    yield true;
                }
                yield false;
            }
            case EntityType.SKELETON, EntityType.WITHER_SKELETON -> {
                if (targetType == EntityType.WOLF) {
                    yield true;
                }
                yield false;
            }
            case EntityType.VILLAGER -> {
                if (targetType == EntityType.ZOMBIE || targetType == EntityType.ZOMBIE_VILLAGER) {
                    yield true;
                }
                yield false;
            }
            case EntityType.PILLAGER, EntityType.VINDICATOR, EntityType.EVOKER, EntityType.ILLUSIONER -> {
                if (targetType == EntityType.CREAKING) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static boolean hostiles(EntityType sourceType, EntityType targetType) {
        return switch (sourceType) {
            case EntityType.IRON_GOLEM, EntityType.SNOW_GOLEM -> {
                if (EntityTypeUtils.isEnemy(targetType) && targetType != EntityType.CREEPER) {
                    yield true;
                }
                yield false;
            }
            case EntityType.FOX -> {
                if (targetType == EntityType.CHICKEN || targetType == EntityType.RABBIT || targetType == EntityType.COD || targetType == EntityType.SALMON || targetType == EntityType.TROPICAL_FISH || targetType == EntityType.PUFFERFISH) {
                    yield true;
                }
                yield false;
            }
            case EntityType.CAT -> {
                if (targetType == EntityType.CHICKEN || targetType == EntityType.RABBIT) {
                    yield true;
                }
                yield false;
            }
            case EntityType.WOLF -> {
                if (EntityTypeUtils.isSkeleton(targetType) || targetType == EntityType.RABBIT || targetType == EntityType.LLAMA || targetType == EntityType.SHEEP || targetType == EntityType.FOX) {
                    yield true;
                }
                yield false;
            }
            case EntityType.GUARDIAN, EntityType.ELDER_GUARDIAN -> {
                if (targetType == EntityType.AXOLOTL || targetType == EntityType.SQUID || targetType == EntityType.GLOW_SQUID) {
                    yield true;
                }
                yield false;
            }
            case EntityType.AXOLOTL -> {
                if (targetType == EntityType.SQUID || targetType == EntityType.GLOW_SQUID || targetType == EntityType.GUARDIAN || targetType == EntityType.ELDER_GUARDIAN || targetType == EntityType.TADPOLE || targetType == EntityType.DROWNED || targetType == EntityType.COD || targetType == EntityType.SALMON || targetType == EntityType.TROPICAL_FISH || targetType == EntityType.PUFFERFISH) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    static {
        nmsClassMap.put(EntityType.PLAYER, Player.class);
        nmsTypeMap = new Object2ObjectArrayMap();
    }

    public record SoundInfo(@Nullable SoundEvent sound, SoundSource source, int interval, float volume) {
    }
}

