/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.utilities;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import xyz.nifeather.morph.utilities.EntityTypeUtils;

public class SoundUtils {
    public static Sound toBukkitSound(EntityTypeUtils.SoundInfo si, float pitch) {
        if (si.sound() == null) {
            return null;
        }
        ResourceLocation resLoc = si.sound().location();
        return (Sound)Sound.sound().source(SoundUtils.toAdventureSource(si.source())).volume(si.volume()).pitch(pitch).type(Key.key((String)resLoc.getNamespace(), (String)resLoc.getPath())).build();
    }

    public static Sound.Source toAdventureSource(SoundSource nmsSource) {
        return switch (nmsSource) {
            default -> throw new MatchException(null, null);
            case SoundSource.MASTER -> Sound.Source.MASTER;
            case SoundSource.MUSIC -> Sound.Source.MUSIC;
            case SoundSource.RECORDS -> Sound.Source.RECORD;
            case SoundSource.WEATHER -> Sound.Source.WEATHER;
            case SoundSource.BLOCKS -> Sound.Source.BLOCK;
            case SoundSource.HOSTILE -> Sound.Source.HOSTILE;
            case SoundSource.NEUTRAL -> Sound.Source.NEUTRAL;
            case SoundSource.PLAYERS -> Sound.Source.PLAYER;
            case SoundSource.AMBIENT -> Sound.Source.AMBIENT;
            case SoundSource.VOICE -> Sound.Source.VOICE;
            case SoundSource.UI -> Sound.Source.UI;
        };
    }
}

