/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.EHasAttackAnimationWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntry;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;

public class CreakingWatcher
extends EHasAttackAnimationWatcher {
    public CreakingWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.CREAKING);
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.CREAKING);
    }

    @Override
    protected <X> void onEntryWrite(CustomEntry<X> entry, X oldVal, X newVal) {
        super.onEntryWrite(entry, oldVal, newVal);
        if (entry.equals(CustomEntries.ANIMATION)) {
            String id = newVal.toString();
            Player bindingPlayer = this.getBindingPlayer();
            World world = bindingPlayer.getWorld();
            switch (id) {
                case "make_active": {
                    this.writePersistent(ValueIndex.CREAKING.IS_ACTIVE, true);
                    world.playSound(bindingPlayer.getLocation(), Sound.ENTITY_CREAKING_ACTIVATE, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "make_inactive": {
                    this.writePersistent(ValueIndex.CREAKING.IS_ACTIVE, false);
                    world.playSound(bindingPlayer.getLocation(), Sound.ENTITY_CREAKING_FREEZE, SoundCategory.HOSTILE, 1.0f, 1.0f);
                }
            }
        }
    }
}

