/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.events.mirror.impl;

import ca.spottedleaf.moonrise.common.util.TickThread;
import java.util.Objects;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.events.InteractionMirrorProcessor;
import xyz.nifeather.morph.events.PlayerTracker;
import xyz.nifeather.morph.events.mirror.ExecutorHub;
import xyz.nifeather.morph.events.mirror.impl.AbstractExecutor;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.NmsRecord;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetSneakingCommand;
import xyz.nifeather.morph.storage.mirrorlogging.OperationType;
import xyz.nifeather.morph.utilities.FoliaThreadUtils;
import xyz.nifeather.morph.utilities.ItemUtils;
import xyz.nifeather.morph.utilities.NmsUtils;

public class ByNameExecutor
extends AbstractExecutor {
    public ByNameExecutor(ExecutorHub executorHub) {
        super(executorHub);
    }

    @Override
    public void reset() {
    }

    @NotNull
    private InteractionMirrorProcessor.PlayerInfo getMirrorTarget(Player player) {
        String targetName = this.getTargetControlFor(player);
        if (targetName == null) {
            return new InteractionMirrorProcessor.PlayerInfo(null, "~NOTSET");
        }
        Player targetPlayer = Bukkit.getPlayerExact((String)targetName);
        InteractionMirrorProcessor.PlayerInfo info = targetPlayer == null || !this.playerNotDisguised(targetPlayer) ? new InteractionMirrorProcessor.PlayerInfo(null, targetName) : new InteractionMirrorProcessor.PlayerInfo(targetPlayer, targetName);
        return info;
    }

    private void scheduleIfNotInSameRegion(Player targetPlayer, Runnable consumer) {
        ServerPlayer nmsPlayer = NmsRecord.ofPlayer(targetPlayer);
        if (!TickThread.isTickThreadFor((net.minecraft.world.entity.Entity)nmsPlayer)) {
            this.scheduleOn((Entity)targetPlayer, consumer);
        } else {
            consumer.run();
        }
    }

    @Override
    public void onSneak(Player player, boolean sneaking) {
        this.applyToNearByMannequin(player, mannequin -> mannequin.setPose(sneaking ? Pose.SNEAKING : Pose.STANDING));
        InteractionMirrorProcessor.PlayerInfo playerInf = this.getMirrorTarget(player);
        Player targetPlayer = playerInf.target();
        if (!this.playerInDistance(player, playerInf.target()) || targetPlayer.isSneaking() == sneaking) {
            return;
        }
        this.scheduleIfNotInSameRegion(targetPlayer, () -> {
            targetPlayer.setSneaking(sneaking);
            this.clientHandler().sendCommand(targetPlayer, (AbstractS2CCommand<?>)new S2CSetSneakingCommand(sneaking));
            this.logOperation(player, targetPlayer, OperationType.ToggleSneak);
        });
    }

    protected void applyToNearByMannequin(Player player, Consumer<Mannequin> consumer) {
        if (!player.hasPermission("feathermorph.mirror.mannequin")) {
            return;
        }
        DisguiseState state = this.morphManager().getDisguiseStateFor(player);
        if (state == null) {
            return;
        }
        if (state.getEntityType() != EntityType.MANNEQUIN) {
            return;
        }
        Location ourLocation = player.getLocation();
        int distance = this.executorHub.getControlDistance();
        player.getWorld().getEntitiesByClass(Mannequin.class).stream().filter(m -> {
            boolean success = true;
            if (distance != -1) {
                success = m.getLocation().distance(ourLocation) <= (double)distance;
            }
            success = success && this.filterMannequin((Mannequin)m, state);
            return success;
        }).forEach(consumer);
    }

    private boolean filterMannequin(@Nullable Mannequin mannequin, DisguiseState state) {
        if (mannequin == null || !FoliaThreadUtils.isTickThreadFor((Entity)mannequin)) {
            return false;
        }
        Component entityName = mannequin.customName();
        Component entityDescription = mannequin.getDescription();
        Object disguiseName = state.disguisePropertyHandler().getOr("entity/custom_name", null);
        Object disguiseDescription = state.disguisePropertyHandler().getOr("mannequin/description", null);
        if (entityName == null && entityDescription == null) {
            return disguiseName == null && disguiseDescription == null;
        }
        return (entityName == null ? disguiseName == null : Objects.equals(entityName, disguiseName)) && (entityDescription == null ? disguiseDescription == null : Objects.equals(entityDescription, disguiseDescription));
    }

    @Override
    public void onSwapHand(Player player) {
        InteractionMirrorProcessor.PlayerInfo playerInf = this.getMirrorTarget(player);
        if (!this.playerInDistance(player, playerInf.target())) {
            return;
        }
        Player targetPlayer = playerInf.target();
        this.scheduleIfNotInSameRegion(targetPlayer, () -> {
            EntityEquipment equipment = targetPlayer.getEquipment();
            ItemStack mainHandItem = equipment.getItemInMainHand();
            ItemStack offhandItem = equipment.getItemInOffHand();
            equipment.setItemInMainHand(offhandItem);
            equipment.setItemInOffHand(mainHandItem);
            this.logOperation(player, targetPlayer, OperationType.SwapHand);
        });
    }

    @Override
    public void onHotbarChange(Player player, int slot) {
        InteractionMirrorProcessor.PlayerInfo inf = this.getMirrorTarget(player);
        if (!this.playerInDistance(player, inf.target())) {
            return;
        }
        Player targetPlayer = inf.target();
        this.scheduleIfNotInSameRegion(targetPlayer, () -> {
            targetPlayer.getInventory().setHeldItemSlot(slot);
            this.logOperation(player, targetPlayer, OperationType.HotbarChange);
        });
    }

    @Override
    public void onStopUsingItem(Player player, ItemStack itemStack) {
        InteractionMirrorProcessor.PlayerInfo inf = this.getMirrorTarget(player);
        if (!this.playerInDistance(player, inf.target())) {
            return;
        }
        Player targetPlayer = inf.target();
        this.scheduleIfNotInSameRegion(targetPlayer, () -> {
            Material ourHandItem = itemStack.getType();
            ServerPlayer nmsPlayer = NmsRecord.ofPlayer(targetPlayer);
            if (nmsPlayer.isUsingItem() && ItemUtils.isContinuousUsable(ourHandItem) && nmsPlayer.getUseItem().getBukkitStack().getType() == ourHandItem) {
                nmsPlayer.releaseUsingItem();
                this.logOperation(player, targetPlayer, OperationType.ReleaseUsingItem);
            }
        });
    }

    @Override
    public boolean onHurtEntity(Player damager, Player hurted) {
        InteractionMirrorProcessor.PlayerInfo inf = this.getMirrorTarget(damager);
        if (!this.playerInDistance(damager, inf.target())) {
            return false;
        }
        Player targetPlayer = inf.target();
        this.simulateOperationAsync(Action.LEFT_CLICK_AIR, targetPlayer, damager, success -> {});
        this.logOperation(damager, targetPlayer, OperationType.LeftClick);
        if (TickThread.isTickThreadFor((net.minecraft.world.entity.Entity)NmsRecord.ofPlayer(targetPlayer))) {
            Entity damagerLookingAt = damager.getTargetEntity(5);
            Entity playerLookingAt = targetPlayer.getTargetEntity(5);
            if (damagerLookingAt != null && damagerLookingAt.equals((Object)playerLookingAt)) {
                return true;
            }
        }
        return hurted.equals((Object)targetPlayer);
    }

    @Override
    public boolean onSwing(Player source) {
        InteractionMirrorProcessor.PlayerInfo inf = this.getMirrorTarget(source);
        Player targetPlayer = inf.target();
        if (targetPlayer == null) {
            return false;
        }
        boolean playerInDistance = this.playerInDistance(source, inf.target());
        if (targetPlayer.getLocation().getWorld().equals((Object)source.getLocation().getWorld()) && playerInDistance && NmsUtils.isTickThreadFor((Entity)targetPlayer) && NmsUtils.isTickThreadFor((Entity)source) && Math.abs(targetPlayer.getLocation().distance(source.getLocation())) <= 6.0) {
            Entity theirTarget = targetPlayer.getTargetEntity(5);
            Entity ourTarget = source.getTargetEntity(5);
            if ((ourTarget != null || theirTarget != null) && (Objects.equals(ourTarget, targetPlayer) || Objects.equals(ourTarget, theirTarget) || Objects.equals(theirTarget, source))) {
                return true;
            }
        }
        if (!playerInDistance) {
            return false;
        }
        PlayerTracker tracker = this.tracker();
        if (tracker.droppingItemThisTick(source)) {
            return false;
        }
        PlayerTracker.InteractType lastAction = tracker.getLastInteractAction(source);
        if (!tracker.interactingThisTick(source)) {
            lastAction = PlayerTracker.InteractType.LEFT_CLICK_AIR;
        }
        if (lastAction == null) {
            return false;
        }
        if (source.getGameMode() == GameMode.SPECTATOR && lastAction.isRightClick()) {
            lastAction = PlayerTracker.InteractType.LEFT_CLICK_BLOCK;
        }
        this.simulateOperationAsync(lastAction.toBukkitAction(), targetPlayer, source, success -> {});
        this.logOperation(source, targetPlayer, lastAction.isLeftClick() ? OperationType.LeftClick : OperationType.RightClick);
        return false;
    }

    @Override
    public void onInteract(Player source, Action action) {
        if (action == Action.PHYSICAL) {
            return;
        }
        if (this.tracker().isDuplicatedRightClick(source)) {
            if (FeatherMorphMain.getInstance().doInternalDebugOutput) {
                this.logger.info("Interact, Duplicated RC " + System.currentTimeMillis());
            }
            return;
        }
        InteractionMirrorProcessor.PlayerInfo inf = this.getMirrorTarget(source);
        if (!this.playerInDistance(source, inf.target())) {
            return;
        }
        Player targetPlayer = inf.target();
        this.simulateOperationAsync(action, targetPlayer, source, success -> {});
        this.logOperation(source, targetPlayer, action.isLeftClick() ? OperationType.LeftClick : OperationType.RightClick);
    }
}

