/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import xyz.nifeather.morph.misc.ISupportDiffs;
import xyz.nifeather.morph.utilities.ItemUtils;

public class DisguiseEquipment
implements ISupportDiffs<DisguiseEquipment> {
    private final Map<EquipmentSlot, ItemStack> itemStackMap = new ConcurrentHashMap<EquipmentSlot, ItemStack>();

    public DisguiseEquipment(Map<EquipmentSlot, ItemStack> items) {
        this.itemStackMap.putAll(items);
    }

    public @Unmodifiable Map<EquipmentSlot, ItemStack> contents() {
        return ImmutableMap.copyOf(this.itemStackMap);
    }

    @NotNull
    public ItemStack getItem(@NotNull EquipmentSlot slot) {
        return this.itemStackMap.getOrDefault(slot, ItemUtils.air.clone());
    }

    @Nullable
    public ItemStack getItemOrNull(@Nullable EquipmentSlot slot) {
        return this.itemStackMap.getOrDefault(slot, null);
    }

    @NotNull
    public ItemStack getItemInMainHand() {
        return this.getItem(EquipmentSlot.HAND);
    }

    @NotNull
    public ItemStack getItemInOffHand() {
        return this.getItem(EquipmentSlot.OFF_HAND);
    }

    public ItemStack getHelmet() {
        return this.getItem(EquipmentSlot.HEAD);
    }

    public ItemStack getChestplate() {
        return this.getItem(EquipmentSlot.CHEST);
    }

    public ItemStack getLeggings() {
        return this.getItem(EquipmentSlot.LEGS);
    }

    public ItemStack getBoots() {
        return this.getItem(EquipmentSlot.FEET);
    }

    public boolean filterAll(Function<ItemStack, Boolean> filter) {
        boolean pass = true;
        for (Map.Entry<EquipmentSlot, ItemStack> entry : this.itemStackMap.entrySet()) {
            pass = filter.apply(entry.getValue()) != false && pass;
        }
        return pass;
    }

    public DisguiseEquipmentBuilder cloneForEdit() {
        return DisguiseEquipment.builder(this);
    }

    public String toString() {
        return "DisguiseEquipment[%s]".formatted(this.itemStackMap.toString());
    }

    public static DisguiseEquipmentBuilder prefilled() {
        return new DisguiseEquipmentBuilder();
    }

    public static DisguiseEquipmentBuilder builder(EntityEquipment other) {
        return new DisguiseEquipmentBuilder(other);
    }

    public static DisguiseEquipmentBuilder builder(DisguiseEquipment other) {
        return new DisguiseEquipmentBuilder(other.itemStackMap);
    }

    public static DisguiseEquipmentBuilder builder(Map<EquipmentSlot, ItemStack> map) {
        return new DisguiseEquipmentBuilder(map);
    }

    public static DisguiseEquipment copy(EntityEquipment other) {
        return DisguiseEquipment.builder(other).build();
    }

    public static DisguiseEquipment empty() {
        return DisguiseEquipment.prefilled().build();
    }

    @Override
    public DisguiseEquipment diff(DisguiseEquipment other) {
        HashMap<EquipmentSlot, ItemStack> changes = new HashMap<EquipmentSlot, ItemStack>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack theirs;
            ItemStack ours = this.getItemOrNull(slot);
            if (Objects.equals(ours, theirs = other.getItemOrNull(slot))) continue;
            changes.put(slot, ItemUtils.itemOrAir(theirs).clone());
        }
        return new DisguiseEquipment(changes);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DisguiseEquipment)) {
            return false;
        }
        DisguiseEquipment other = (DisguiseEquipment)obj;
        return other.itemStackMap.equals(this.itemStackMap);
    }

    public static class DisguiseEquipmentBuilder {
        private final Map<EquipmentSlot, ItemStack> itemMap = new ConcurrentHashMap<EquipmentSlot, ItemStack>();

        private static Map<EquipmentSlot, ItemStack> airMap() {
            ConcurrentHashMap<EquipmentSlot, ItemStack> itemMap = new ConcurrentHashMap<EquipmentSlot, ItemStack>();
            for (EquipmentSlot value : EquipmentSlot.values()) {
                itemMap.put(value, ItemUtils.air.clone());
            }
            return itemMap;
        }

        public DisguiseEquipmentBuilder() {
            this(DisguiseEquipmentBuilder.airMap());
        }

        public DisguiseEquipmentBuilder(@NotNull EntityEquipment entityEquipment) {
            this(Map.of(EquipmentSlot.HEAD, ItemUtils.itemOrAir(entityEquipment.getHelmet()).clone(), EquipmentSlot.CHEST, ItemUtils.itemOrAir(entityEquipment.getChestplate()).clone(), EquipmentSlot.LEGS, ItemUtils.itemOrAir(entityEquipment.getLeggings()).clone(), EquipmentSlot.FEET, ItemUtils.itemOrAir(entityEquipment.getBoots()).clone(), EquipmentSlot.HAND, ItemUtils.itemOrAir(entityEquipment.getItemInMainHand()).clone(), EquipmentSlot.OFF_HAND, ItemUtils.itemOrAir(entityEquipment.getItemInOffHand()).clone()));
        }

        public DisguiseEquipmentBuilder(Map<EquipmentSlot, ItemStack> existing) {
            this.itemMap.putAll(existing);
        }

        public DisguiseEquipmentBuilder helmet(@NotNull ItemStack stack) {
            return this.forSlot(EquipmentSlot.HEAD, stack);
        }

        public DisguiseEquipmentBuilder chestplate(@NotNull ItemStack stack) {
            return this.forSlot(EquipmentSlot.CHEST, stack);
        }

        public DisguiseEquipmentBuilder leggings(@NotNull ItemStack stack) {
            return this.forSlot(EquipmentSlot.LEGS, stack);
        }

        public DisguiseEquipmentBuilder boots(@NotNull ItemStack stack) {
            return this.forSlot(EquipmentSlot.FEET, stack);
        }

        public DisguiseEquipmentBuilder mainHand(@NotNull ItemStack stack) {
            return this.forSlot(EquipmentSlot.HAND, stack);
        }

        public DisguiseEquipmentBuilder offHand(@NotNull ItemStack stack) {
            return this.forSlot(EquipmentSlot.OFF_HAND, stack);
        }

        public DisguiseEquipmentBuilder forSlot(EquipmentSlot slot, @NotNull ItemStack stack) {
            Objects.requireNonNull(stack, "Null item is not accepted");
            this.itemMap.put(slot, stack);
            return this;
        }

        public DisguiseEquipmentBuilder mergeIfNotNull(@Nullable DisguiseEquipment other) {
            if (other != null) {
                this.merge(other);
            }
            return this;
        }

        public DisguiseEquipmentBuilder merge(DisguiseEquipment other) {
            other.itemStackMap.forEach(this::forSlot);
            return this;
        }

        public DisguiseEquipment build() {
            return new DisguiseEquipment(this.itemMap);
        }
    }
}

