/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc;

import java.util.Random;
import net.kyori.adventure.sound.Sound;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import org.bukkit.SoundCategory;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.config.ConfigOption;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.NmsRecord;
import xyz.nifeather.morph.utilities.DisguiseUtils;
import xyz.nifeather.morph.utilities.EntityTypeUtils;
import xyz.nifeather.morph.utilities.MathUtils;
import xyz.nifeather.morph.utilities.SoundUtils;

public class SoundHandler {
    public int ambientInterval = 0;
    public Sound ambientSoundPrimary;
    public Sound ambientSoundSecondary;
    private int soundTime;
    private double soundFrequency = 0.0;
    private float soundVolume = 1.0f;
    private final Player bindingPlayer;
    @Nullable
    private EntityType entityType;
    private SoundCategory soundCategory = SoundCategory.PLAYERS;
    private final Random random = new Random();
    private final MorphConfigManager config = MorphConfigManager.getInstance();

    public void resetSoundTime() {
        this.soundTime = 0;
    }

    @NotNull
    private EntityType getEntityType() {
        return this.entityType == null ? EntityType.PLAYER : this.entityType;
    }

    public SoundHandler(Player bindingPlayer) {
        this.bindingPlayer = bindingPlayer;
    }

    public void update() {
        ++this.soundTime;
        double frequencyScale = 1.0 / this.soundFrequency;
        if (this.ambientInterval != 0 && (double)this.soundTime >= (double)this.ambientInterval * frequencyScale && !this.bindingPlayer.isSneaking()) {
            EntityEquipment eq;
            boolean playSecondary = false;
            if (this.getEntityType() == EntityType.ALLAY && !(eq = this.bindingPlayer.getEquipment()).getItemInMainHand().getType().isAir()) {
                playSecondary = true;
            }
            Sound sound = playSecondary ? this.ambientSoundSecondary : this.ambientSoundPrimary;
            ServerPlayer nmsPlayer = NmsRecord.ofPlayer(this.bindingPlayer);
            boolean isSpectator = nmsPlayer.isSpectator();
            if (isSpectator) {
                this.soundTime = -((int)((double)this.ambientInterval * frequencyScale));
            } else if (sound != null && this.random.nextInt((int)(1000.0 * frequencyScale)) < this.soundTime) {
                this.soundTime = -((int)((double)this.ambientInterval * frequencyScale));
                this.bindingPlayer.getWorld().playSound(this.bindingPlayer.getLocation(), sound.name().asString(), this.soundCategory, this.soundVolume, 1.0f);
            }
        }
    }

    public void resetSound() {
        this.ambientSoundPrimary = null;
        this.ambientSoundSecondary = null;
        this.ambientInterval = 0;
        this.resetSoundTime();
    }

    public void refreshSounds(DisguiseState bindingSession, EntityType entityType, boolean isBaby) {
        this.resetSound();
        this.entityType = entityType;
        this.soundFrequency = MathUtils.clamp(0.0, 2.0, this.config.getBindable(Double.class, ConfigOption.AMBIENT_FREQUENCY).get());
        EntityTypeUtils.SoundInfo soundEvent = DisguiseUtils.getAmbientSound(bindingSession, entityType, this.bindingPlayer.getWorld(), this.bindingPlayer.getLocation());
        SoundEvent sound = soundEvent.sound();
        if (sound == null) {
            return;
        }
        this.soundVolume = soundEvent.volume();
        this.ambientInterval = soundEvent.interval();
        float pitch = isBaby ? 1.5f : 1.0f;
        this.ambientSoundPrimary = SoundUtils.toBukkitSound(soundEvent, pitch);
        boolean isEnemy = EntityTypeUtils.isEnemy(entityType);
        SoundCategory soundCategory = this.soundCategory = isEnemy ? SoundCategory.HOSTILE : SoundCategory.NEUTRAL;
        if (entityType == EntityType.ALLAY) {
            SoundEvent allaySecondary = SoundEvents.ALLAY_AMBIENT_WITH_ITEM;
            EntityTypeUtils.SoundInfo secSi = new EntityTypeUtils.SoundInfo(allaySecondary, SoundSource.NEUTRAL, this.ambientInterval, soundEvent.volume());
            this.ambientSoundSecondary = SoundUtils.toBukkitSound(secSi, pitch);
        }
    }
}

