/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.shaded.pluginbase.Configuration.ConfigNode;
import xyz.nifeather.morph.shaded.pluginbase.Configuration.ConfigOption;

public abstract class StandaloneYamlConfigManager
extends MorphPluginObject {
    protected YamlConfiguration backendConfiguration;
    @NotNull
    protected final File configFile;
    @Nullable
    private final String internalResourceName;
    public static final ConfigOption<Integer> CONFIG_VERSION = new ConfigOption<Integer>(ConfigNode.create().append("version"), 0);

    public StandaloneYamlConfigManager(@NotNull File file, @Nullable String internalResourceName) {
        this.configFile = file;
        this.internalResourceName = internalResourceName;
    }

    protected abstract boolean copyInternalResource();

    protected abstract int getExpectedConfigVersion();

    public void reload() {
        int configVersion;
        YamlConfiguration newConfig = new YamlConfiguration();
        if (!this.configFile.exists() && !this.copyInternalResource()) {
            this.logger.error("Can't create file to save configuration! Not reloading recipes...");
            return;
        }
        try {
            newConfig.load(this.configFile);
        }
        catch (Throwable e) {
            this.logger.error("Unable to load recipe configuration: " + e.getMessage());
            return;
        }
        if (this.backendConfiguration == null) {
            this.backendConfiguration = newConfig;
        }
        if ((configVersion = newConfig.getInt(CONFIG_VERSION.toString(), 0)) < this.getExpectedConfigVersion()) {
            this.migrate(this.backendConfiguration, newConfig);
            this.logger.info("Recipe configuration migrate done, reloading...");
            this.reload();
        } else {
            this.logger.info("Done reloading recipe configuration");
            this.backendConfiguration = newConfig;
        }
    }

    @NotNull
    protected Map<ConfigNode, Object> getAllNotDefault(Collection<ConfigOption<?>> options) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (ConfigOption<?> o : options) {
            Object val = o.getDefault() instanceof List ? this.getList(o) : (o.getDefault() instanceof Map ? this.getMap(o) : this.getOrDefault(o, o.getDefault()));
            if (o.getDefault().equals(val)) continue;
            map.put((Object)o.node(), val);
        }
        return map;
    }

    protected abstract List<ConfigOption<?>> getAllOptions();

    private void migrate(@Nullable YamlConfiguration currentConfig, YamlConfiguration newConfig) {
        Map<ConfigNode, Object> allNotDefault = this.getAllNotDefault(this.getAllOptions());
        if (this.internalResourceName != null) {
            this.plugin.saveResource(this.internalResourceName, true);
        }
        this.onMigrate(currentConfig, newConfig, allNotDefault);
        allNotDefault.forEach((node, val) -> {
            ConfigOption matching = this.getAllOptions().stream().filter(option -> option.node().equals(node)).findFirst().orElse(null);
            if (matching == null) {
                return;
            }
            newConfig.set(node.toString(), val);
        });
    }

    protected void onMigrate(@Nullable YamlConfiguration currentConfig, YamlConfiguration newConfig, Map<ConfigNode, Object> nonDefaultValues) {
    }

    public <T> T get(ConfigOption<T> option) {
        return this.getOrDefault(option, null);
    }

    @NotNull
    public List<String> getList(ConfigOption<?> option) {
        String node = option.toString();
        return this.backendConfiguration.getStringList(node);
    }

    @Nullable
    public Map<String, String> getMap(ConfigOption<?> option) {
        String node = option.toString();
        ConfigurationSection configSection = this.backendConfiguration.getConfigurationSection(node);
        if (configSection == null) {
            return null;
        }
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        configSection.getKeys(false).forEach(arg_0 -> StandaloneYamlConfigManager.lambda$getMap$2((Map)map, configSection, arg_0));
        return map;
    }

    public <T> T getOrDefault(ConfigOption<T> option) {
        return this.getOrDefault(option, option.getDefault());
    }

    public <T> T getOrDefault(ConfigOption<T> option, T defaultVal) {
        String node = option.toString();
        Object backendResult = this.backendConfiguration.get(node, defaultVal);
        if (backendResult == null && defaultVal == null) {
            return null;
        }
        T optionDefault = option.getDefault();
        if (List.class.isAssignableFrom(optionDefault.getClass())) {
            throw new IllegalArgumentException("Use getList() instead.");
        }
        if (Map.class.isAssignableFrom(optionDefault.getClass())) {
            throw new IllegalArgumentException("Use getMap() instead.");
        }
        if (optionDefault.getClass().isAssignableFrom(backendResult.getClass())) {
            return (T)backendResult;
        }
        return defaultVal;
    }

    private static /* synthetic */ void lambda$getMap$2(Map map, ConfigurationSection configSection, String key) {
        map.put(key, configSection.getString(key));
    }
}

