/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityProperties;
import xyz.nifeather.morph.utilities.DisguiseUtils;

public class AxolotlProperties
extends BaseLivingEntityProperties<Axolotl> {
    private final Map<String, Axolotl.Variant> variantMap = new ConcurrentHashMap<String, Axolotl.Variant>();
    public final SingleProperty<Axolotl.Variant> VARIANT = this.createProperty("axolotl/variant", Axolotl.Variant.LUCY, this::readAxolotlVariant, OutputHandles::writeEnum).withRandom((Axolotl.Variant[])Axolotl.Variant.values());

    private void initVariantMap() {
        for (Axolotl.Variant variant : Axolotl.Variant.values()) {
            this.variantMap.put(variant.name().toLowerCase(), variant);
        }
    }

    public Optional<Axolotl.Variant> readAxolotlVariant(String propertyName, String input) throws ParseErrorException {
        return InputHandles.readEnumNonNull((Enum[])Axolotl.Variant.values(), (String)propertyName, (String)input);
    }

    public AxolotlProperties() {
        this.initVariantMap();
        this.VARIANT.withValidInput(this.variantMap.keySet());
        this.registerSingle((SingleProperty<?>)this.VARIANT);
    }

    @Override
    @Nullable
    protected Axolotl tryCastEntity(@Nullable Entity targetEntity) {
        Axolotl axolotl;
        return targetEntity instanceof Axolotl ? (axolotl = (Axolotl)targetEntity) : null;
    }

    @Override
    public void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Axolotl axolotl) {
        super.setupPropertiesFromEntity(meta, propertyHandler, axolotl);
        propertyHandler.set(this.VARIANT, axolotl.getVariant());
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        propertyHandler.set(this.VARIANT, DisguiseUtils.pick(this.VARIANT.getRandomValues()));
    }
}

