/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.MainHand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.messages.strings.CommandStrings;
import xyz.nifeather.morph.messages.strings.ExceptionStrings;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyValidationException;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityProperties;
import xyz.nifeather.morph.misc.skins.PlayerSkinProvider;
import xyz.nifeather.morph.utilities.GameProfileUtils;
import xyz.nifeather.morph.utilities.Uuids;

public class PlayerProperties
extends BaseLivingEntityProperties<Player> {
    public final SingleProperty<MainHandStatus> MAIN_HAND = this.createProperty("player/main_hand", MainHandStatus.NOTSET, this::readHand, OutputHandles::writeEnum).withValidInput("left", "right");
    public final SingleProperty<GameProfile> SKIN = SingleProperty.of("player/skin", new GameProfile(Uuids.NIL_UUID, "unknown"), InputHandles::readGameProfile, OutputHandles::writeGameProfile, true);

    @Override
    protected SingleProperty<Component> createCustomNameProperty() {
        return this.createProperty("entity/custom_name", Component.empty(), InputHandles::unsupported, OutputHandles::writeAdventureComponentJSON);
    }

    private Optional<MainHandStatus> readHand(String propertyName, String string) throws ParseErrorException {
        if (string.equalsIgnoreCase("notset")) {
            throw ParseErrorException.forProperty(propertyName).byMethod("readHand").withLocalizableMessage(ExceptionStrings.inputNotAllowed()).withMessage("This value is not allowed here!").create();
        }
        return InputHandles.readEnumNonNull((Enum[])MainHandStatus.values(), (String)propertyName, (String)string);
    }

    public PlayerProperties() {
        this.registerSingle(this.MAIN_HAND, this.SKIN);
    }

    @Override
    @Nullable
    protected Player tryCastEntity(@Nullable Entity targetEntity) {
        Player player;
        return targetEntity instanceof Player ? (player = (Player)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Player targetEntity) {
        super.setupPropertiesFromEntity(meta, propertyHandler, targetEntity);
        propertyHandler.set(this.MAIN_HAND, MainHandStatus.fromBukkitHand(targetEntity.getMainHand()));
        propertyHandler.set(this.STUCKED_ARROWS, targetEntity.getArrowsInBody());
        if (meta.playerDisguiseTargetName != null && meta.playerDisguiseTargetName.equalsIgnoreCase(targetEntity.getName())) {
            propertyHandler.set(this.SKIN, GameProfileUtils.convertPlayerProfile(targetEntity.getPlayerProfile()));
        }
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
    }

    @Override
    public void validateInput(Map<SingleProperty<?>, Object> result, Player player, boolean ignorePermissions) throws PropertyValidationException {
        super.validateInput(result, player, ignorePermissions);
        if (result.containsKey(this.SKIN)) {
            GameProfile skin = (GameProfile)result.get(this.SKIN);
            boolean skinMatchesCache = Objects.equals(PlayerSkinProvider.getInstance().getCachedProfile(skin.name()), skin);
            if (!(ignorePermissions || skinMatchesCache || player.hasPermission("feathermorph.custom_skin"))) {
                throw PropertyValidationException.forProperty("player/skin").byMethod("PlayerProperties#validateInput").withLocalizableMessage(CommandStrings.noPermissionMessage()).withMessage("Player don't have permission for setting custom skin").create();
            }
            if (skin.id().equals(Uuids.NIL_UUID)) {
                throw PropertyValidationException.forProperty("player/skin").byMethod("PlayerProperties#validateInput").withLocalizableMessage(ExceptionStrings.inputNotAllowed()).withMessage("UUID of the skin may not be ZERO").create();
            }
        }
    }

    public static enum MainHandStatus {
        LEFT(MainHand.LEFT),
        RIGHT(MainHand.RIGHT),
        NOTSET(null);

        @Nullable
        public final MainHand bindingHand;

        private MainHandStatus(MainHand hand) {
            this.bindingHand = hand;
        }

        public static MainHandStatus fromBukkitHand(MainHand hand) {
            return hand == MainHand.LEFT ? LEFT : RIGHT;
        }

        @Nullable
        public MainHand toBukkitHand() {
            return this.bindingHand;
        }
    }
}

