/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.skills;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.MorphPluginObject;

public class CooldownManager
extends MorphPluginObject {
    private final Map<UUID, CooldownStore> storeMap = new ConcurrentHashMap<UUID, CooldownStore>();

    private CooldownStore getStore(UUID uuid) {
        CooldownStore store = this.storeMap.getOrDefault(uuid, null);
        if (store == null) {
            store = new CooldownStore();
            this.storeMap.put(uuid, store);
        }
        return store;
    }

    public synchronized void submit(UUID uuid, String disguiseIdentifier, long availableAfter) {
        this.getStore(uuid).put(disguiseIdentifier, availableAfter);
    }

    public synchronized long pull(UUID uuid, String disguiseIdentifier) {
        return this.getStore(uuid).get(disguiseIdentifier);
    }

    public synchronized void trim() {
        for (Map.Entry<UUID, CooldownStore> pair : new HashSet<Map.Entry<UUID, CooldownStore>>(this.storeMap.entrySet())) {
            if (!pair.getValue().trim()) continue;
            this.storeMap.remove(pair.getKey());
        }
    }

    public static class CooldownStore {
        private final Map<String, Long> cooldownMap = new ConcurrentHashMap<String, Long>();

        public void put(String id, long availableAfter) {
            this.cooldownMap.put(id, availableAfter);
        }

        public long get(String id) {
            if (this.cooldownMap.containsKey(id)) {
                return this.cooldownMap.remove(id);
            }
            return 0L;
        }

        public boolean trim() {
            long currentTick = FeatherMorphMain.getInstance().getCurrentTick();
            HashSet<Map.Entry<String, Long>> entries = new HashSet<Map.Entry<String, Long>>(this.cooldownMap.entrySet());
            List<Map.Entry> list = entries.stream().filter(entry -> currentTick > (Long)entry.getValue()).toList();
            list.forEach(entrySet -> this.cooldownMap.remove(entrySet.getKey()));
            return this.cooldownMap.isEmpty();
        }
    }
}

