/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.utilities;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.Holder;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DamageSourceUtils {
    public static NotScalableDamageSource toNotScalable(DamageSource source) {
        return new NotScalableDamageSource(source);
    }

    public static class NotScalableDamageSource
    extends DamageSource {
        public final List<TagKey<DamageType>> tags = new CopyOnWriteArrayList<TagKey<DamageType>>();
        private boolean noSourceLocation;

        public NotScalableDamageSource(DamageSource source) {
            this((Holder<DamageType>)source.typeHolder(), source.getDirectEntity(), source.getEntity());
        }

        public NotScalableDamageSource(Holder<DamageType> type, @Nullable Entity source, @Nullable Entity attacker) {
            super(type, source, attacker);
        }

        public NotScalableDamageSource(Holder<DamageType> type, Vec3 position) {
            super(type, position);
        }

        public NotScalableDamageSource(Holder<DamageType> type, @Nullable Entity attacker) {
            super(type, attacker);
        }

        public NotScalableDamageSource(Holder<DamageType> type) {
            super(type);
        }

        public boolean scalesWithDifficulty() {
            return false;
        }

        public boolean is(@NotNull TagKey<DamageType> tag) {
            return super.is(tag) || this.tags.contains(tag);
        }

        @Nullable
        public Vec3 getSourcePosition() {
            return this.noSourceLocation ? null : super.getSourcePosition();
        }

        public NotScalableDamageSource noSourceLocation() {
            this.noSourceLocation = true;
            return this;
        }

        public NotScalableDamageSource withTag(TagKey<DamageType> tag) {
            this.tags.add(tag);
            return this;
        }

        public NotScalableDamageSource bypassArmor() {
            this.tags.add((TagKey<DamageType>)DamageTypeTags.BYPASSES_ARMOR);
            return this;
        }

        public NotScalableDamageSource bypassResistance() {
            this.tags.add((TagKey<DamageType>)DamageTypeTags.BYPASSES_RESISTANCE);
            return this;
        }

        public NotScalableDamageSource bypassShield() {
            this.tags.add((TagKey<DamageType>)DamageTypeTags.BYPASSES_SHIELD);
            return this;
        }

        public NotScalableDamageSource bypassEnchantments() {
            this.tags.add((TagKey<DamageType>)DamageTypeTags.BYPASSES_ENCHANTMENTS);
            return this;
        }

        public NotScalableDamageSource bypassEverything() {
            this.bypassArmor().bypassShield().bypassResistance().bypassEnchantments();
            return this;
        }
    }
}

