/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.fmccl.network.commands;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SCommand;
import xyz.nifeather.fmccl.network.commands.S2C.NetheriteS2CCommand;

public class CommandRegistries {
    private final Object2ObjectArrayMap<String, Function<String, NetheriteC2SCommand<?>>> c2sCmds = new Object2ObjectArrayMap();
    private final Object2ObjectArrayMap<String, Function<String, NetheriteS2CCommand<?>>> s2cCmds = new Object2ObjectArrayMap();

    public CommandRegistries registerC2S(String name, Function<String, NetheriteC2SCommand<?>> function) {
        this.c2sCmds.put((Object)name, function);
        return this;
    }

    public CommandRegistries registerS2C(String name, Function<String, NetheriteS2CCommand<?>> function) {
        this.s2cCmds.put((Object)name, function);
        return this;
    }

    @Nullable
    public NetheriteS2CCommand<?> createS2CCommand(String baseName, String args) {
        Function func = (Function)this.s2cCmds.getOrDefault((Object)baseName, null);
        return func == null ? null : (NetheriteS2CCommand)func.apply(args);
    }

    @Nullable
    public NetheriteC2SCommand<?> createC2SCommand(String baseName, String args) {
        Function func = (Function)this.c2sCmds.getOrDefault((Object)baseName, null);
        return func == null ? null : (NetheriteC2SCommand)func.apply(args);
    }
}

