/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.fmccl.network.commands.S2C;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.fmccl.network.BasicServerHandler;
import xyz.nifeather.fmccl.network.annotations.Environment;
import xyz.nifeather.fmccl.network.annotations.EnvironmentType;

public abstract class NetheriteS2CCommand<T> {
    @NotNull
    protected List<T> arguments;
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();

    public NetheriteS2CCommand() {
        this.arguments = new ArrayList<T>();
    }

    public NetheriteS2CCommand(@Nullable T argument) {
        this.arguments = this.toList(argument);
    }

    public NetheriteS2CCommand(@Nullable T[] arguments) {
        this.arguments = this.toList(arguments);
    }

    @SafeVarargs
    private List<T> toList(T ... elements) {
        if (elements == null) {
            return new ArrayList();
        }
        return Arrays.stream(elements).toList();
    }

    public abstract String getBaseName();

    @Environment(value=EnvironmentType.CLIENT)
    public abstract void onCommand(BasicServerHandler<?> var1);

    public String buildCommand() {
        return (this.getBaseName() + " " + this.serializeArguments()).trim();
    }

    protected static Gson gson() {
        return gson;
    }

    public String serializeArguments() {
        if (this.arguments.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (T argument : this.arguments) {
            builder.append(argument).append(" ");
        }
        return builder.toString().trim();
    }

    @Nullable
    public T getArgumentAt(int index) {
        return index >= this.arguments.size() ? null : (T)this.arguments.get(index);
    }

    @NotNull
    public T getArgumentAt(int index, @NotNull T defaultValue) {
        T val = this.getArgumentAt(index);
        return val == null ? defaultValue : val;
    }
}

