/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.fmccl.network.commands.S2C;

import java.util.Arrays;
import xyz.nifeather.fmccl.network.BasicServerHandler;
import xyz.nifeather.fmccl.network.annotations.Environment;
import xyz.nifeather.fmccl.network.annotations.EnvironmentType;
import xyz.nifeather.fmccl.network.commands.S2C.NetheriteS2CCommand;

public class NetheriteS2CRequestCommand
extends NetheriteS2CCommand<String> {
    @Environment(value=EnvironmentType.CLIENT)
    public NetheriteRequestType netheriteRequestType;
    @Environment(value=EnvironmentType.CLIENT)
    public String sourcePlayer;

    @Environment(value=EnvironmentType.CLIENT)
    public NetheriteS2CRequestCommand(String rawArgs) {
        super((T[])rawArgs.split(" "));
        this.initialize();
    }

    public NetheriteS2CRequestCommand(NetheriteRequestType requestNetheriteRequestType, String source) {
        super((T[])new String[]{requestNetheriteRequestType.commandName, source});
        this.initialize();
    }

    private void initialize() {
        String typeStr = this.getArgumentAt(0, "?");
        this.netheriteRequestType = Arrays.stream(NetheriteRequestType.values()).filter(t -> t.commandName.equalsIgnoreCase(typeStr)).findFirst().orElse(NetheriteRequestType.Unknown);
        this.sourcePlayer = this.getArgumentAt(1, "Unknown source");
    }

    @Override
    public String getBaseName() {
        return "request";
    }

    @Override
    @Environment(value=EnvironmentType.CLIENT)
    public void onCommand(BasicServerHandler<?> handler) {
        handler.onExchangeRequestReceive(this);
    }

    public static enum NetheriteRequestType {
        NewRequest("new"),
        RequestSend("send_success"),
        RequestExpired("expire"),
        RequestExpiredOwner("expire_owner"),
        RequestAccepted("player_accept"),
        RequestDenied("player_deny"),
        Unknown("unknown_type");

        public final String commandName;

        public boolean isRequestOwner() {
            return this == RequestExpiredOwner || this == RequestSend || this == RequestAccepted || this == RequestDenied;
        }

        private NetheriteRequestType(String cmdName) {
            this.commandName = cmdName;
        }
    }
}

