/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectBooleanMutablePair;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.abilities.IAbility;
import xyz.nifeather.morph.config.ConfigOptions;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.permissions.CommonPermissions;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.storage.skill.IAbilityConfigLookup;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;
import xyz.nifeather.morph.utilities.PermissionUtils;

public class AbilityUpdater
extends MorphPluginObject
implements IAbilityConfigLookup {
    @NotNull
    private final DisguiseState parentState;
    private final List<IAbility<?>> pendingAbilities = Collections.synchronizedList(new ObjectArrayList());
    private final List<Pair<IAbility<?>, Boolean>> registeredAbilities = new CopyOnWriteArrayList();
    private Bindable<Boolean> checkAbilityPermissions = new Bindable<Boolean>(true);
    private final Map<String, ISkillAbilityOption> abilityConfigMap = new ConcurrentHashMap<String, ISkillAbilityOption>();

    @Initializer
    private void load(MorphConfigManager config) {
        this.checkAbilityPermissions = config.getBindable(ConfigOptions.DO_CHECK_ABILITY_PERMISSIONS);
    }

    public AbilityUpdater(@NotNull DisguiseState parentState) {
        this.parentState = parentState;
    }

    private Player player() {
        return this.parentState.getPlayer();
    }

    private void disableAbility(Pair<IAbility<?>, Boolean> pair, Player player) {
        ((IAbility)pair.left()).revokeFromPlayer(player, this.parentState);
        pair.right((Object)false);
    }

    private void enableAbility(Pair<IAbility<?>, Boolean> pair, Player player) {
        ((IAbility)pair.left()).applyToPlayer(player, this.parentState);
        pair.right((Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        ObjectArrayList pending = new ObjectArrayList();
        Player player = this.player();
        List<IAbility<?>> list = this.pendingAbilities;
        synchronized (list) {
            pending.addAll(this.pendingAbilities);
            if (!pending.isEmpty()) {
                for (IAbility ability : pending) {
                    boolean hasPermission = this.checkAbilityPermissions.get() == false || AbilityUpdater.hasPermissionFor(ability, this.parentState);
                    ObjectBooleanMutablePair pair = new ObjectBooleanMutablePair((Object)ability, hasPermission);
                    if (hasPermission) {
                        ability.applyToPlayer(player, this.parentState);
                    }
                    this.registeredAbilities.add((Pair<IAbility<?>, Boolean>)pair);
                }
                this.pendingAbilities.clear();
            }
        }
        for (Pair pair : this.registeredAbilities) {
            IAbility ability;
            ability = (IAbility)pair.left();
            Boolean enabled = (Boolean)pair.right();
            if (this.checkAbilityPermissions.get().booleanValue() && this.plugin.getCurrentTick() % 5L == 0L) {
                boolean hasPermission = AbilityUpdater.hasPermissionFor(ability, this.parentState);
                if (hasPermission && !enabled.booleanValue()) {
                    this.enableAbility(pair, player);
                    enabled = true;
                } else if (!hasPermission && enabled.booleanValue()) {
                    this.disableAbility(pair, player);
                    enabled = false;
                }
            } else if (!this.checkAbilityPermissions.get().booleanValue() && !enabled.booleanValue()) {
                this.enableAbility(pair, player);
                enabled = true;
            }
            if (!enabled.booleanValue()) continue;
            ability.handle(player, this.parentState);
        }
    }

    public void reApplyAbility() {
        this.registeredAbilities.forEach(pair -> {
            if (((Boolean)pair.right()).booleanValue()) {
                ((IAbility)pair.left()).revokeFromPlayer(this.player(), this.parentState);
                ((IAbility)pair.left()).applyToPlayer(this.player(), this.parentState);
            }
        });
    }

    public void onPlayerOffline() {
        this.registeredAbilities.forEach(pair -> ((IAbility)pair.left()).revokeFromPlayer(this.player(), this.parentState));
    }

    public boolean containsAbility(NamespacedKey identifier) {
        return this.registeredAbilities.stream().anyMatch(pair -> ((IAbility)pair.left()).getIdentifier().equals((Object)identifier));
    }

    public @Unmodifiable List<IAbility<?>> getEnabledAbilities() {
        return this.registeredAbilities.stream().filter(Pair::right).map(Pair::left).collect(Collectors.toUnmodifiableList());
    }

    public boolean setAbilities(@NotNull List<IAbility<?>> abilities) {
        this.getEnabledAbilities().forEach(a -> a.revokeFromPlayer(this.player(), this.parentState));
        this.registeredAbilities.clear();
        return this.addAbilities(abilities);
    }

    @Nullable
    public IAbility<?> getAbilityInstance(NamespacedKey identifier) {
        Optional<Pair> optional = this.registeredAbilities.stream().filter(pair -> ((IAbility)pair.left()).getIdentifier().equals((Object)identifier)).findFirst();
        return optional.map(Pair::left).orElse(null);
    }

    public OperationResult removeAbility(NamespacedKey targetIdentifier) {
        IAbility<?> ability = this.getAbilityInstance(targetIdentifier);
        if (ability == null) {
            return OperationResult.FAIL_NOT_EXIST;
        }
        ability.revokeFromPlayer(this.player(), this.parentState);
        this.registeredAbilities.removeIf(pair -> ((IAbility)pair.left()).equals(ability));
        return OperationResult.SUCCESS;
    }

    public boolean addAbilities(IAbility<?> ... abilities) {
        return this.addAbilities(Arrays.stream(abilities).toList());
    }

    public boolean addAbilities(List<IAbility<?>> abilities) {
        boolean success = true;
        for (IAbility<?> ability : abilities) {
            success = success && this.addAbility(ability) == OperationResult.SUCCESS;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult addAbility(IAbility<?> ability) {
        List<IAbility<?>> list = this.pendingAbilities;
        synchronized (list) {
            if (this.pendingAbilities.stream().anyMatch(a -> a.getIdentifier().equals((Object)ability.getIdentifier()))) {
                return OperationResult.FAIL_ALREADY_EXISTS;
            }
            this.pendingAbilities.add(ability);
        }
        return OperationResult.SUCCESS;
    }

    public @Unmodifiable List<IAbility<?>> getRegisteredAbilities() {
        return this.registeredAbilities.stream().map(Pair::left).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public void dispose() {
        this.getEnabledAbilities().forEach(a -> a.revokeFromPlayer(this.player(), this.parentState));
        this.setAbilities(List.of());
    }

    public static boolean hasPermissionFor(IAbility<?> ability, DisguiseState state) {
        String singleAbilityPerm = CommonPermissions.abilityPermissionOf(ability.getIdentifier().asString(), state.getDisguiseIdentifier());
        return PermissionUtils.hasPermission(state.getPlayer(), singleAbilityPerm, true);
    }

    @Override
    @Nullable
    public <X> X lookupAbilityConfig(String identifier, Class<X> expectedClass) {
        ISkillAbilityOption val = this.abilityConfigMap.getOrDefault(identifier, null);
        if (val == null) {
            return null;
        }
        if (expectedClass.isInstance(val)) {
            return (X)val;
        }
        return null;
    }

    @Override
    public void setAbilityConfig(String identifier, ISkillAbilityOption config) {
        this.abilityConfigMap.put(identifier, config);
    }

    public static enum OperationResult {
        SUCCESS,
        FAIL_UNKNOWN,
        FAIL_ALREADY_EXISTS,
        FAIL_NOT_EXIST;

    }
}

