/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities.impl;

import io.papermc.paper.chat.ChatRenderer;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.concurrent.atomic.AtomicReference;
import net.kyori.adventure.audience.Audience;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.abilities.MorphAbility;
import xyz.nifeather.morph.abilities.options.ChatOverrideOption;
import xyz.nifeather.morph.api.morphs.abilities.AbilityNames;
import xyz.nifeather.morph.config.ConfigOptions;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.MorphChatRenderer;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;
import xyz.nifeather.morph.shaded.pluginbase.Messages.MessageStore;

public class ChatOverrideAbility
extends MorphAbility<ChatOverrideOption> {
    private final Bindable<Boolean> useCustomRenderer = new Bindable<Boolean>(false);
    private final Bindable<Boolean> allowChatOverride = new Bindable<Boolean>(true);
    @Resolved
    private MorphManager morphs;

    @Override
    @NotNull
    public ISkillAbilityOptionHandler<ChatOverrideOption> optionHandler() {
        return ChatOverrideOption.OPTION_HANDLER;
    }

    @Override
    @NotNull
    public NamespacedKey getIdentifier() {
        return AbilityNames.CHAT_OVERRIDE;
    }

    @Initializer
    private void load(MorphConfigManager config, MessageStore<?> messageStore) {
        config.bind(this.allowChatOverride, ConfigOptions.ALLOW_CHAT_OVERRIDE);
        config.bind(this.useCustomRenderer, ConfigOptions.CHAT_OVERRIDE_USE_CUSTOM_RENDERER);
    }

    @Override
    public boolean handle(Player player, DisguiseState state) {
        return true;
    }

    @EventHandler
    public void onChat(AsyncChatEvent e) {
        if (!this.allowChatOverride.get().booleanValue()) {
            return;
        }
        Player player = e.getPlayer();
        if (!this.isPlayerApplied(player) || !player.hasPermission("feathermorph.chatoverride")) {
            return;
        }
        DisguiseState state = this.morphs.getDisguiseStateFor(player);
        assert (state != null);
        FormattableMessage formattable = this.getFormattableMessage(state);
        if (this.useCustomRenderer.get().booleanValue()) {
            e.renderer((ChatRenderer)new MorphChatRenderer(formattable));
        } else {
            e.renderer().render(player, state.getServerDisplay(), e.message(), (Audience)player);
        }
    }

    @Nullable
    private FormattableMessage getFormattableMessage(DisguiseState state) {
        AtomicReference<FormattableMessage> targetString = new AtomicReference<FormattableMessage>();
        ChatOverrideOption p = (ChatOverrideOption)this.getOptionFor(state);
        if (p != null) {
            String pattern = p.getMessagePattern();
            if (pattern == null) {
                return null;
            }
            targetString.set(new FormattableMessage(this.plugin, pattern));
        }
        return (FormattableMessage)targetString.get();
    }
}

