/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities.impl;

import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.Vec3;
import org.bukkit.GameEvent;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.abilities.MorphAbility;
import xyz.nifeather.morph.abilities.options.FlyOption;
import xyz.nifeather.morph.api.morphs.abilities.AbilityNames;
import xyz.nifeather.morph.config.ConfigOptions;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.permissions.CommonPermissions;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.BindableList;
import xyz.nifeather.morph.utilities.MathUtils;
import xyz.nifeather.morph.utilities.PermissionUtils;

public class FlyAbility
extends MorphAbility<FlyOption> {
    private final BindableList<String> noFlyWorlds = new BindableList();
    private final BindableList<String> noFlyInLavaWorlds = new BindableList();
    private final BindableList<String> noFlyInWaterWorlds = new BindableList();
    private final Bindable<Boolean> allowFlight = new Bindable<Boolean>(true);
    private final float exhaustionBase = 0.005f;
    private double idleConsumption = 0.05;
    private double exhaustionScaled = 0.005;
    @Resolved
    private MorphManager manager;
    private static final Map<Player, Stack<Object>> blockedPlayersMap = new ConcurrentHashMap<Player, Stack<Object>>();

    @Override
    @NotNull
    public ISkillAbilityOptionHandler<FlyOption> optionHandler() {
        return FlyOption.OPTION_HANDLER;
    }

    @Override
    @NotNull
    public NamespacedKey getIdentifier() {
        return AbilityNames.CAN_FLY;
    }

    @Override
    public boolean applyToPlayer(Player player, DisguiseState state) {
        if (super.applyToPlayer(player, state)) {
            return this.updateFlyingState(state);
        }
        return false;
    }

    @Initializer
    private void load(MorphConfigManager configManager) {
        configManager.getBindable(ConfigOptions.FLYABILITY_EXHAUSTION_BASE).onValueChanged((o, n) -> {
            double scale = ConfigOptions.FLYABILITY_EXHAUSTION_BASE.getDefault() / n;
            this.exhaustionScaled = (double)0.005f * scale;
        }, true);
        configManager.bind(String.class, this.noFlyWorlds, ConfigOptions.NOFLY_WORLDS);
        configManager.getBindable(ConfigOptions.FLYABILITY_IDLE_CONSUME).onValueChanged((o, n) -> {
            this.idleConsumption = n != false ? 0.1 : 0.0;
        }, true);
        configManager.bind(this.allowFlight, ConfigOptions.ALLOW_FLIGHT);
        configManager.bind(String.class, this.noFlyInLavaWorlds, ConfigOptions.FLYABILITY_DISALLOW_FLY_IN_LAVA);
        configManager.bind(String.class, this.noFlyInWaterWorlds, ConfigOptions.FLYABILITY_DISALLOW_FLY_IN_WATER);
    }

    @Override
    public boolean handle(Player player, DisguiseState state) {
        boolean playerCanFly;
        boolean allowFlight;
        if (this.plugin.getCurrentTick() % 2L != 0L) {
            return true;
        }
        ServerPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        GameType gameMode = nmsPlayer.gameMode.getGameModeForPlayer();
        if (gameMode == GameType.CREATIVE || gameMode == GameType.SPECTATOR) {
            return true;
        }
        FlyOption option = (FlyOption)this.getOptionFor(state);
        if (option == null) {
            return false;
        }
        String worldName = player.getWorld().getName();
        boolean allowFlightConditions = !(player.getFoodLevel() <= option.getMinimumHunger() || this.noFlyWorlds.contains(worldName) || FlyAbility.playerBlocked(player) || !this.playerHasCommonFlyPerm(player) || this.noFlyInLavaWorlds.contains(worldName) && player.isInLava() || this.noFlyInWaterWorlds.contains(worldName) && player.isInWater());
        boolean bl = allowFlight = this.allowFlight.get() != false && (allowFlightConditions || player.hasPermission("feathermorph.can_fly.always"));
        if (player.isFlying()) {
            double delta;
            if (this.plugin.getCurrentTick() % 10L == 0L) {
                float configSpeed = option.getFlyingSpeed();
                if (player.getFlySpeed() != configSpeed && nmsPlayer.gameMode.isSurvival()) {
                    player.setFlySpeed(configSpeed);
                }
            }
            if (player.getVehicle() == null) {
                Vec3 old = new Vec3(nmsPlayer.xOld, nmsPlayer.yOld, nmsPlayer.zOld);
                Vec3 cur = nmsPlayer.position();
                delta = Math.max(this.idleConsumption, cur.distanceTo(old));
            } else {
                delta = 0.0;
            }
            float exhaustion = this.handleMovementForSpeed(delta);
            nmsPlayer.getFoodData().addExhaustion(exhaustion);
            if (player.getTicksLived() % 5 == 0) {
                player.getWorld().sendGameEvent((Entity)player, GameEvent.FLAP, player.getLocation().toVector());
            }
            if (!allowFlight) {
                player.setFlying(false);
            }
        }
        if ((playerCanFly = nmsPlayer.getAbilities().mayfly) != allowFlight) {
            player.setAllowFlight(allowFlight);
        }
        return true;
    }

    private boolean playerHasCommonFlyPerm(Player player) {
        String worldPerm = CommonPermissions.CanFlyIn(player.getWorld().getName());
        return player.hasPermission("feathermorph.can_fly") && PermissionUtils.hasPermission(player, worldPerm, true);
    }

    private float handleMovementForSpeed(double movementDelta) {
        float movementBase = 0.25f;
        float movementMultiplier = (float)movementDelta / movementBase;
        return (float)this.exhaustionScaled * movementMultiplier;
    }

    @Override
    public boolean revokeFromPlayer(Player player, DisguiseState state) {
        super.revokeFromPlayer(player, state);
        GameMode gamemode = player.getGameMode();
        if (gamemode != GameMode.CREATIVE && gamemode != GameMode.SPECTATOR) {
            player.setAllowFlight(false);
        }
        player.setFlySpeed(0.1f);
        return true;
    }

    public float getTargetFlySpeed(DisguiseState state) {
        if (state == null) {
            return Float.NaN;
        }
        FlyOption value = (FlyOption)this.getOptionFor(state);
        if (value != null) {
            return value.getFlyingSpeed();
        }
        return Float.NaN;
    }

    public boolean updateFlyingState(DisguiseState state) {
        Player player = state.getPlayer();
        player.setAllowFlight(true);
        if (player.getGameMode() != GameMode.SPECTATOR) {
            float speed = this.getTargetFlySpeed(state);
            speed = Float.isNaN(speed) ? 0.1f : MathUtils.clamp(-1.0f, 1.0f, speed);
            player.setFlySpeed(speed);
        }
        return true;
    }

    @EventHandler
    public void onGameModeChange(PlayerGameModeChangeEvent e) {
        Player player = e.getPlayer();
        if (!this.isPlayerApplied(player)) {
            return;
        }
        DisguiseState state = this.manager.getDisguiseStateFor(player);
        if (state != null) {
            boolean flying = player.isFlying();
            this.addSchedule(() -> {
                if (this.isPlayerApplied(player)) {
                    this.updateFlyingState(state);
                    if (flying) {
                        player.setFlying(true);
                    }
                }
            });
        } else {
            this.logger.warn(player.getName() + " have fly ability applied, but its DisguiseState is null? Revoking...");
            this.revokeFromPlayer(player, null);
        }
    }

    public static boolean playerBlocked(Player player) {
        Stack stack = blockedPlayersMap.getOrDefault(player, null);
        return stack != null && !stack.isEmpty();
    }

    public static void blockPlayer(Player player, Object requestSource) {
        Stack<Object> stack = blockedPlayersMap.getOrDefault(player, null);
        if (stack == null) {
            stack = new Stack<Object>();
            blockedPlayersMap.put(player, stack);
        }
        if (!stack.contains(requestSource)) {
            stack.push(requestSource);
        }
    }

    public static void unBlockPlayer(Player player, Object requestSource) {
        Stack stack = blockedPlayersMap.getOrDefault(player, new Stack());
        stack.remove(requestSource);
    }
}

