/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.client;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.backends.DisguiseBackend;
import xyz.nifeather.morph.backends.DisguiseWrapper;
import xyz.nifeather.morph.backends.WrapperProperties;
import xyz.nifeather.morph.backends.client.ModDisguiseWrapper;
import xyz.nifeather.morph.backends.client.TrackingClientDisguise;
import xyz.nifeather.morph.messages.strings.BackendStrings;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.ExecutionErrorException;
import xyz.nifeather.morph.misc.ModNetworkingHelper;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRRegisterCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRSetMetaCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRSyncRegisterCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRUnregisterCommand;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class ModBackend
extends DisguiseBackend<TrackingClientDisguise, ModDisguiseWrapper> {
    private final Map<Player, ModDisguiseWrapper> playerFallbackWrapperMap = new Object2ObjectOpenHashMap();
    @Resolved(shouldSolveImmediately=true)
    private ModNetworkingHelper modNetworkingHelper;
    @Resolved
    private MorphClientHandler clientHandler;

    @Override
    public String getIdentifier() {
        return "client";
    }

    @Override
    public FormattableMessage getDisplayName() {
        return BackendStrings.clientBackendName();
    }

    @Override
    public DisguiseWrapper<TrackingClientDisguise> createInstance(EntityType entityType) {
        return new ModDisguiseWrapper(new TrackingClientDisguise(entityType), this);
    }

    @Override
    public DisguiseWrapper<TrackingClientDisguise> createPlayerInstance(String targetPlayerName) {
        ModDisguiseWrapper wrapper = new ModDisguiseWrapper(new TrackingClientDisguise(EntityType.PLAYER), this);
        wrapper.setDisguiseName(targetPlayerName);
        return wrapper;
    }

    @Override
    public TrackingClientDisguise createRawInstance(Entity entity) {
        return new TrackingClientDisguise(entity.getType());
    }

    @Override
    public boolean isDisguised(@Nullable Entity target) {
        return this.playerFallbackWrapperMap.containsKey(target);
    }

    @Override
    public ModDisguiseWrapper getWrapper(Entity target) {
        if (!(target instanceof Player)) {
            return null;
        }
        Player player = (Player)target;
        return this.playerFallbackWrapperMap.getOrDefault(player, null);
    }

    @Override
    @NotNull
    public ModDisguiseWrapper cloneWrapperFrom(DisguiseWrapper<?> otherWrapper) {
        ModDisguiseWrapper modDisguiseWrapper;
        if (otherWrapper instanceof ModDisguiseWrapper) {
            ModDisguiseWrapper modDisguiseWrapper2 = (ModDisguiseWrapper)otherWrapper;
            modDisguiseWrapper = this.cloneWrapper(modDisguiseWrapper2);
        } else {
            modDisguiseWrapper = this.cloneOther(otherWrapper);
        }
        return modDisguiseWrapper;
    }

    private ModDisguiseWrapper cloneWrapper(ModDisguiseWrapper other) {
        return (ModDisguiseWrapper)other.clone();
    }

    private ModDisguiseWrapper cloneOther(DisguiseWrapper<?> other) {
        return ModDisguiseWrapper.fromExternal(other, this);
    }

    ModNetworkingHelper getNetworkingHelper() {
        return this.modNetworkingHelper;
    }

    @Override
    public void disguise(Player player, DisguiseWrapper<?> rawWrapper) throws ExecutionErrorException {
        if (!(rawWrapper instanceof ModDisguiseWrapper)) {
            throw ExecutionErrorException.forMethod("ModBackend#disguise").withMessage("The given disguise wrapper is not an instance of ModDisguiseWrapper.").create();
        }
        ModDisguiseWrapper wrapper = (ModDisguiseWrapper)rawWrapper;
        if (this.playerFallbackWrapperMap.containsKey(player)) {
            this.unDisguise(player);
        }
        ObjectArrayList players = new ObjectArrayList(this.featherMorph().getPlatform().onlinePlayersNative());
        players.remove((Object)player);
        S2CCRRegisterCommand cmd = new S2CCRRegisterCommand(player.getEntityId(), wrapper.readPropertyOrThrow(WrapperProperties.DISGUISE_ID));
        players.forEach(p -> this.clientHandler.sendCommand((Player)p, (AbstractS2CCommand<?>)cmd));
        this.modNetworkingHelper.prepareMeta((Entity)player).forWrapper(rawWrapper).send();
        wrapper.setBindingPlayer(player);
        this.playerFallbackWrapperMap.put(player, wrapper);
    }

    public S2CCRSyncRegisterCommand generateRenderSyncCommand(MorphManager morphManager) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (DisguiseState disguiseState : morphManager.getActiveDisguises()) {
            Player player = disguiseState.getPlayer();
            map.put(player.getEntityId(), disguiseState.getDisguiseIdentifier());
        }
        return S2CCRSyncRegisterCommand.of(map);
    }

    @Override
    public void onClientModInitialize(Player player, MorphClientHandler clientHandler, MorphManager morphManager) {
        clientHandler.sendCommand(player, (AbstractS2CCommand<?>)this.generateRenderSyncCommand(morphManager));
        List<DisguiseState> disguises = morphManager.getActiveDisguises();
        for (DisguiseState bindingState : disguises) {
            Player bindingPlayer = bindingState.getPlayer();
            S2CCRSetMetaCommand packet = this.modNetworkingHelper.prepareMeta((Entity)bindingPlayer).forDisguiseState(bindingState).build();
            clientHandler.sendCommand(player, (AbstractS2CCommand<?>)packet);
        }
    }

    @Override
    public boolean unDisguise(Player player) {
        ModDisguiseWrapper wrapper = this.playerFallbackWrapperMap.getOrDefault(player, null);
        if (wrapper != null) {
            wrapper.dispose();
        }
        S2CCRUnregisterCommand cmd = new S2CCRUnregisterCommand(player.getEntityId());
        ObjectArrayList players = new ObjectArrayList(this.featherMorph().getPlatform().onlinePlayersNative());
        players.remove((Object)player);
        players.forEach(p -> this.clientHandler.sendCommand((Player)p, (AbstractS2CCommand<?>)cmd));
        this.playerFallbackWrapperMap.remove(player);
        return true;
    }

    @Override
    @Nullable
    public ModDisguiseWrapper fromOfflineSave(String offlineParameter) {
        return null;
    }

    @Override
    @Nullable
    public String toOfflineSave(DisguiseWrapper<?> wrapper) {
        return null;
    }

    @Override
    public Collection<ModDisguiseWrapper> listInstances() {
        return this.playerFallbackWrapperMap.values();
    }
}

