/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import net.minecraft.nbt.CompoundTag;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.LivingEntityWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntry;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.CreeperPropertyCollection;

public class CreeperWatcher
extends LivingEntityWatcher {
    public CreeperWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.CREEPER);
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.CREEPER);
    }

    @Override
    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
        CreeperPropertyCollection properties = DisguiseProperties.INSTANCE.getCollectionOrThrow(CreeperPropertyCollection.class);
        if (property.equals(properties.CHARGED)) {
            boolean isCharged = Boolean.TRUE.equals(value);
            this.writePersistent(ValueIndex.CREEPER.IS_CHARGED_CREEPER, isCharged);
        }
        super.onPropertyWrite(property, value);
    }

    @Override
    protected <X> void onEntryWrite(CustomEntry<X> entry, X oldVal, X newVal) {
        super.onEntryWrite(entry, oldVal, newVal);
        if (entry.equals(CustomEntries.IS_AGGRESSIVE)) {
            boolean aggressive = (Boolean)newVal;
            this.writePersistent(ValueIndex.CREEPER.STATE, aggressive ? 1 : -1);
            this.writePersistent(ValueIndex.CREEPER.IGNITED, aggressive);
        }
    }

    @Override
    public void writeToCompound(CompoundTag nbt) {
        super.writeToCompound(nbt);
        nbt.putBoolean("powered", this.read(ValueIndex.CREEPER.IS_CHARGED_CREEPER).booleanValue());
    }
}

