/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.listeners;

import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.sound.Sound;
import com.github.retrooper.packetevents.protocol.sound.StaticSound;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSoundEffect;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.SingleWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.listeners.ProtocolListener;
import xyz.nifeather.morph.backends.server.renderer.network.registries.RenderRegistry;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.utilities.EntityTypeUtils;

public class SoundListener
extends ProtocolListener {
    @Resolved(shouldSolveImmediately=true)
    private RenderRegistry registry;

    @Override
    public String getIdentifier() {
        return "sound";
    }

    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType() != PacketType.Play.Server.SOUND_EFFECT) {
            return;
        }
        Player targetPlayer = (Player)event.getPlayer();
        if (targetPlayer == null) {
            return;
        }
        WrapperPlayServerSoundEffect wrapper = new WrapperPlayServerSoundEffect(event);
        Vector3i effectPosition = wrapper.getEffectPosition();
        Location positionAsLocation = new Location(targetPlayer.getWorld(), (double)effectPosition.x, (double)effectPosition.y, (double)effectPosition.z);
        SingleWatcher matchingWatcher = this.registry.getWatchers().stream().filter(w -> {
            if (!w.isActive()) {
                return false;
            }
            Location playerLocation = w.getBindingPlayer().getLocation();
            if (!Objects.equals(playerLocation.getWorld(), positionAsLocation.getWorld())) {
                return false;
            }
            int locX = (int)(playerLocation.x() * 8.0);
            int locY = (int)(playerLocation.y() * 8.0);
            int locZ = (int)(playerLocation.z() * 8.0);
            return effectPosition.x == locX && effectPosition.y == locY && effectPosition.z == locZ;
        }).findFirst().orElse(null);
        if (matchingWatcher == null || matchingWatcher.getEntityType() == EntityType.PLAYER) {
            return;
        }
        event.markForReEncode(true);
        ResourceLocation sound = wrapper.getSound().getSoundId();
        String path = sound.toString();
        if (path.endsWith(".hurt") || path.endsWith(".hurt_on_fire") || path.endsWith(".hurt_drown") || path.endsWith(".hurt_freeze") || path.endsWith(".hurt_sweet_berry_bush")) {
            String soundId = EntityTypeUtils.getDamageSoundKey(matchingWatcher.getEntityType());
            if (soundId == null) {
                return;
            }
            ResourceLocation rL = new ResourceLocation(soundId);
            wrapper.setSound((Sound)new StaticSound(rL, Float.valueOf(wrapper.getVolume())));
        }
    }
}

