/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands.subcommands.plugin;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.api.events.lifecycle.ConfigurationReloadEvent;
import xyz.nifeather.morph.commands.brigadier.BrigadierCommand;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.TranslateManager;
import xyz.nifeather.morph.messages.strings.CommandStrings;
import xyz.nifeather.morph.messages.strings.HelpStrings;
import xyz.nifeather.morph.messages.vanilla.MasterVanillaMessageStore;
import xyz.nifeather.morph.misc.skins.PlayerSkinProvider;
import xyz.nifeather.morph.network.multiInstance.MultiInstanceService;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;
import xyz.nifeather.morph.shaded.pluginbase.Messages.MessageStore;
import xyz.nifeather.morph.storage.skill.SkillsConfigurationStoreNew;

public class ReloadSubCommand
extends BrigadierCommand {
    @Resolved
    private MorphManager morphManager;
    @Resolved
    private MorphConfigManager config;
    @Resolved
    private MessageStore<?> messageStore;
    @Resolved
    private MasterVanillaMessageStore masterVanillaMessageStore;
    @Resolved
    private SkillsConfigurationStoreNew skills;
    @Resolved
    private MultiInstanceService multiInstanceService;
    private final List<String> subcommands = ObjectImmutableList.of((Object[])new String[]{"data", "message"});

    @Override
    @NotNull
    public String name() {
        return "reload";
    }

    @Override
    @Nullable
    public String getPermissionRequirement() {
        return "feathermorph.reload";
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return HelpStrings.reloadDescription();
    }

    @Override
    public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
        parentBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(this::checkPermission)).executes(this::execNoArg)).then(Commands.argument((String)"operation", (ArgumentType)StringArgumentType.greedyString()).suggests(this::suggests).executes(this::executes)));
        super.registerAsChild(parentBuilder);
    }

    @NotNull
    public CompletableFuture<Suggestions> suggests(CommandContext<CommandSourceStack> context, SuggestionsBuilder suggestionsBuilder) {
        return CompletableFuture.supplyAsync(() -> {
            suggestionsBuilder.suggest("*");
            String input = suggestionsBuilder.getRemainingLowerCase();
            List<String> target = this.subcommands.stream().filter(s -> s.startsWith(input)).toList();
            target.forEach(arg_0 -> ((SuggestionsBuilder)suggestionsBuilder).suggest(arg_0));
            return suggestionsBuilder.build();
        });
    }

    private int execNoArg(CommandContext<CommandSourceStack> context) {
        this.doReload(context, true, true);
        return 1;
    }

    private void doReload(CommandContext<CommandSourceStack> context, boolean reloadsData, boolean reloadsMessage) {
        if (reloadsData) {
            this.config.reload();
            this.skills.clearCache();
            this.morphManager.reload();
            PlayerSkinProvider.getInstance().reload();
            this.multiInstanceService.onReload();
        }
        if (reloadsMessage) {
            TranslateManager.instance().reload();
            this.masterVanillaMessageStore.reloadConfiguration();
        }
        ConfigurationReloadEvent event = new ConfigurationReloadEvent(reloadsData, reloadsMessage);
        event.callEvent();
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        MessageUtils.send(sender, CommandStrings.reloadCompleteMessage());
    }

    public int executes(CommandContext<CommandSourceStack> context) {
        String option;
        boolean reloadsData = false;
        boolean reloadsMessage = false;
        switch (option = StringArgumentType.getString(context, (String)"operation")) {
            case "data": {
                reloadsData = true;
                break;
            }
            case "message": {
                reloadsMessage = true;
                break;
            }
            default: {
                reloadsData = true;
                reloadsMessage = true;
            }
        }
        this.doReload(context, reloadsData, reloadsMessage);
        return 0;
    }
}

