/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands.subcommands.plugin.extract;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.commands.brigadier.BrigadierCommand;
import xyz.nifeather.morph.commands.brigadier.arguments.RelaxedStringArgumentType;
import xyz.nifeather.morph.messages.DumpResult;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.strings.CommandStrings;
import xyz.nifeather.morph.messages.strings.OperationStrings;
import xyz.nifeather.morph.messages.strings.TypesString;
import xyz.nifeather.morph.misc.ConfirmationHandler;
import xyz.nifeather.morph.misc.ExecutionErrorException;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;
import xyz.nifeather.morph.utilities.PluginAssetUtils;

public class DumpLanguageCommand
extends BrigadierCommand {
    private final List<String> validLocale;
    private final ConfirmationHandler<CommandSender> confirmationHandler = new ConfirmationHandler();

    @Override
    @Nullable
    public String getPermissionRequirement() {
        return "feathermorph.admin";
    }

    @Override
    @NotNull
    public String name() {
        return "language";
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return null;
    }

    public DumpLanguageCommand() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(PluginAssetUtils.allSupportedLanguages()).add((Object)"*");
        this.validLocale = builder.build();
        this.confirmationHandler.onSubmit().hook((sender, duration) -> {
            FormattableMessage msg = CommandStrings.confirmationRequired().resolve("second", duration.getSeconds()).resolve("operation", OperationStrings.overwritingOneOrMore().resolve("type", TypesString.localeFile()));
            MessageUtils.send(sender, msg);
        });
        this.confirmationHandler.onExpire().hook(sender -> {
            FormattableMessage msg = CommandStrings.confirmationExpired().resolve("operation", OperationStrings.overwritingOneOrMore().resolve("type", TypesString.localeFile()));
            MessageUtils.send(sender, msg);
        });
        Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)FeatherMorphMain.getInstance(), task -> this.confirmationHandler.update(), 1L, 10L);
    }

    @Override
    public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
        parentBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)this.name()).requires(this::checkPermission)).then(((RequiredArgumentBuilder)Commands.argument((String)"locale", (ArgumentType)RelaxedStringArgumentType.relaxed()).suggests(this::suggestLocale).executes(c -> this.dumpLocale((CommandContext<CommandSourceStack>)c, false))).then(Commands.argument((String)"overwrite_existing", (ArgumentType)BoolArgumentType.bool()).executes(c -> this.dumpLocale((CommandContext<CommandSourceStack>)c, BoolArgumentType.getBool((CommandContext)c, (String)"overwrite_existing"))))));
        super.registerAsChild(parentBuilder);
    }

    private CompletableFuture<Suggestions> suggestLocale(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return CompletableFuture.supplyAsync(() -> {
            String input = builder.getRemainingLowerCase();
            this.validLocale.stream().filter(s -> s.contains(input)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.build();
        });
    }

    private int dumpLocale(CommandContext<CommandSourceStack> context, boolean overwrite) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        if (overwrite && !this.confirmationHandler.confirm(sender)) {
            this.confirmationHandler.submit(sender, Duration.ofSeconds(15L));
            return 0;
        }
        String locale = StringArgumentType.getString(context, (String)"locale");
        if (locale.equals("*")) {
            int result = 0;
            for (String s : PluginAssetUtils.allSupportedLanguages()) {
                result += this.doExtract(sender, s, overwrite);
            }
            return result;
        }
        return this.doExtract(sender, locale, overwrite);
    }

    private int doExtract(CommandSender sender, String locale, boolean overwriteExisting) {
        String path = PluginAssetUtils.langPath(locale);
        Optional<String> stringOptional = PluginAssetUtils.getFileStringsOptional(path);
        if (stringOptional.isEmpty()) {
            MessageUtils.send(sender, CommandStrings.assetNotFound().resolve("type", TypesString.localeFile()));
            return 0;
        }
        File messagesDirectory = new File(this.plugin.getDataFolder(), "messages");
        try {
            DumpResult result = PluginAssetUtils.extractLocaleFile(locale, messagesDirectory, overwriteExisting);
            FormattableMessage msg = CommandStrings.dumpSuccess().resolve("what", locale).resolve("type", TypesString.localeFile()).resolve("path", result.resultFile().getAbsolutePath());
            MessageUtils.send(sender, msg);
            return 1;
        }
        catch (ExecutionErrorException e) {
            this.logger.error("Unable to dump file", (Throwable)e);
            MessageUtils.send(sender, CommandStrings.unableToWrite().resolve("path", messagesDirectory.getAbsolutePath()));
            return 0;
        }
    }
}

