/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.events;

import io.papermc.paper.event.connection.configuration.AsyncPlayerConnectionConfigureEvent;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.storage.playerdata.PlayerMeta;

public class PlayerConfigurator
extends MorphPluginObject
implements Listener {
    @Resolved(shouldSolveImmediately=true)
    private MorphManager morphManager;
    @Resolved(shouldSolveImmediately=true)
    private MorphClientHandler clientHandler;

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void postPlayerConfiguration(AsyncPlayerConnectionConfigureEvent e) {
        UUID uuid = e.getConnection().getProfile().getId();
        if (uuid == null) {
            this.logger.warn("The server have an incoming player connection, but don't know their UUID! Not pulling disguise data...");
            return;
        }
        long waitTime = 150L;
        try {
            CompletableFuture<PlayerMeta> future = this.morphManager.loadPlayerDataAsync(uuid);
            future.thenAccept(meta -> this.onPlayerMeta(uuid, (PlayerMeta)meta));
            if (waitTime > 0L) {
                future.get(waitTime, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            // empty catch block
        }
    }

    private void onPlayerMeta(UUID uuid, PlayerMeta playerMeta) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return;
        }
        this.clientHandler.refreshPlayerClientMorphs(playerMeta.getUnlockedDisguiseIdentifiers(), player);
    }
}

