/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.messages;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.messages.OverlayingMessageStore;
import xyz.nifeather.morph.misc.ExecutionErrorException;
import xyz.nifeather.morph.shaded.pluginbase.Exceptions.NullDependencyException;
import xyz.nifeather.morph.shaded.pluginbase.Messages.IStrings;
import xyz.nifeather.morph.shaded.pluginbase.Messages.MessageStore;
import xyz.nifeather.morph.utilities.PluginAssetUtils;

public class TranslateManager {
    private static final TranslateManager instance = new TranslateManager();
    private final Logger logger = LoggerFactory.getLogger((String)"FeatherMorph$TranslateManager");
    private final Map<String, OverlayingMessageStore> messageStoreMap = new ConcurrentHashMap<String, OverlayingMessageStore>();
    public static final String FALLBACK_LOCALE = "en_us";

    public static TranslateManager instance() {
        return instance;
    }

    public TranslateManager() {
        this.init();
    }

    private void init() {
        this.logger.info("Initializing translate manager");
        this.setupLanguage(FALLBACK_LOCALE);
        File messagesDirectory = new File(FeatherMorphMain.getInstance().getDataFolder(), "messages");
        for (String lang : PluginAssetUtils.allSupportedLanguages()) {
            try {
                this.logger.info("Extracting default locale files... (This won't affect existing files)");
                PluginAssetUtils.extractLocaleFile(lang, messagesDirectory, false);
                this.logger.info("Done Extracting default locale files");
            }
            catch (ExecutionErrorException e) {
                this.logger.warn("Error occurred extracting default locale files, ignoring", (Throwable)e);
            }
        }
        this.logger.info("Done initializing translate manager");
    }

    public void setupLanguage(String locale) {
        OverlayingMessageStore store = new OverlayingMessageStore(locale);
        try {
            store.load();
        }
        catch (Throwable t) {
            this.logger.error("Failed to load i18n store for language %s".formatted(locale), t);
        }
        this.messageStoreMap.put(locale, store);
        this.logger.info("Done loading i18n store for language %s".formatted(locale));
    }

    public OverlayingMessageStore lookTranslateStoreOrCreate(String locale) {
        if (!this.messageStoreMap.containsKey(locale)) {
            this.setupLanguage(locale);
        }
        return this.lookupTranslateStore(locale).orElseThrow();
    }

    public Optional<OverlayingMessageStore> lookupTranslateStore(String locale) {
        return Optional.ofNullable(this.messageStoreMap.getOrDefault(locale, null));
    }

    public OverlayingMessageStore getDefaultTranslateStore() {
        return this.lookupTranslateStore(FALLBACK_LOCALE).orElseThrow(() -> new NullDependencyException("No"));
    }

    public Optional<String> lookupTranslate(String rawLocale, String messageKey) {
        return this.lookupTranslate(rawLocale, messageKey, true);
    }

    public Optional<String> lookupTranslate(String rawLocale, String messageKey, boolean allowFallback) {
        String locale = rawLocale.toLowerCase(Locale.ROOT);
        OverlayingMessageStore translateStore = this.lookTranslateStoreOrCreate(rawLocale);
        Optional<String> result = translateStore.lookup(messageKey);
        if (result.isPresent()) {
            return result;
        }
        if (allowFallback && !translateStore.targetLocale().equals(FALLBACK_LOCALE)) {
            Optional<String> defaultResult = this.lookupTranslate(FALLBACK_LOCALE, messageKey);
            return defaultResult.or(() -> Optional.of("[%s:%s]".formatted(locale, messageKey)));
        }
        return result;
    }

    public void reload() {
        this.messageStoreMap.values().forEach(OverlayingMessageStore::reload);
    }

    public MessageStore<FeatherMorphMain> asFrameworkMessageStore() {
        return new FrameworkMessageStoreBinding(this);
    }

    public static class FrameworkMessageStoreBinding
    extends MessageStore<FeatherMorphMain> {
        private final TranslateManager translate;

        public FrameworkMessageStoreBinding(TranslateManager translateManager) {
            this.translate = translateManager;
            this.storingObject = new HashMap();
        }

        @Override
        protected List<Class<? extends IStrings>> getStrings() {
            return List.of();
        }

        @Override
        protected String getPluginNamespace() {
            return FeatherMorphMain.getMorphNameSpace();
        }

        @Override
        public void initializeStorage(boolean noReload) {
        }

        @Override
        public void addMissingStrings() {
        }

        @Override
        public String get(String key, @Nullable String defaultValue, @Nullable String locale) {
            return this.translate.lookupTranslate("override", key, false).orElseGet(() -> this.translate.lookupTranslate(locale == null ? TranslateManager.FALLBACK_LOCALE : locale, key).orElse(key));
        }
    }
}

