/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.mirror.impl.executors;

import io.papermc.paper.event.player.PlayerArmSwingEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.events.PlayerTracker;
import xyz.nifeather.morph.mirror.ExecutorHub;
import xyz.nifeather.morph.mirror.IExecutor;
import xyz.nifeather.morph.mirror.IOperationHandle;
import xyz.nifeather.morph.mirror.SimulateResult;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.storage.mirrorlogging.OperationType;
import xyz.nifeather.morph.utilities.ItemUtils;

public abstract class AbstractExecutor
extends MorphPluginObject
implements IExecutor<Player, ItemStack, Action> {
    protected final ExecutorHub executorHub;
    @Resolved(shouldSolveImmediately=true)
    private MorphManager manager;
    @Resolved(shouldSolveImmediately=true)
    private MorphClientHandler clientHandler;
    @Resolved
    private PlayerTracker tracker;

    public AbstractExecutor(ExecutorHub executorHub) {
        this.executorHub = executorHub;
    }

    protected void logOperation(Player source, LivingEntity targetPlayer, OperationType type) {
        this.executorHub.logOperation(source, targetPlayer, type);
    }

    protected PlayerTracker tracker() {
        return this.tracker;
    }

    protected MorphClientHandler clientHandler() {
        return this.clientHandler;
    }

    protected MorphManager morphManager() {
        return this.manager;
    }

    protected boolean playerNotDisguised(Player player) {
        return this.manager.getDisguiseStateFor(player) == null;
    }

    @Contract(value="_, null-> false; _, !null -> _")
    protected <E extends LivingEntity> boolean playerInDistance(@NotNull Player source, @Nullable E target) {
        if (target == null) {
            return false;
        }
        IOperationHandle<E> handle = this.executorHub.lookupOperationHandle(target);
        if (!handle.operationAllowed(source) || !handle.affectedByMirror(target)) {
            return false;
        }
        boolean isInSameWorld = target.getWorld().equals((Object)source.getWorld());
        int normalDistance = this.executorHub.getControlDistance();
        return normalDistance == -1 || normalDistance != 0 && isInSameWorld && target.getLocation().distance(source.getLocation()) <= (double)normalDistance;
    }

    protected <E extends LivingEntity> void simulateOperationAsync(Action action, E target, Player source, Consumer<Boolean> callback) {
        AtomicBoolean success = new AtomicBoolean(false);
        target.getScheduler().run((Plugin)this.plugin, task -> {
            success.set(this.simulateOperation(action, target, source));
            callback.accept(success.get());
        }, () -> {});
    }

    protected <E extends LivingEntity> boolean simulateOperation(Action action, E target, Player source) {
        if (target instanceof Player) {
            Player targetPlayer = (Player)target;
            if (this.tracker().interactingThisTick(targetPlayer)) {
                return false;
            }
        }
        boolean isRightClick = action.isRightClick();
        IOperationHandle<E> simulator = this.executorHub.lookupOperationHandle(target);
        SimulateResult result = isRightClick ? simulator.simulateRightClick(target) : simulator.simulateLeftClick(target);
        boolean success = false;
        if (result.success()) {
            Material itemInUse;
            EntityEquipment equipment = target.getEquipment();
            Material material = itemInUse = equipment == null ? Material.AIR : target.getEquipment().getItem(result.hand()).getType();
            if (!isRightClick || !ItemUtils.isContinuousUsable(itemInUse) || result.forceSwing()) {
                Player player;
                boolean allowed;
                boolean bl = allowed = !(target instanceof Player) || new PlayerArmSwingEvent(player = (Player)target, result.hand()).callEvent();
                if (allowed) {
                    target.swingHand(result.hand());
                }
            }
            success = true;
        }
        return success;
    }
}

