/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.mirror.impl.executors;

import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.events.PlayerTracker;
import xyz.nifeather.morph.mirror.ExecutorHub;
import xyz.nifeather.morph.mirror.IOperationHandle;
import xyz.nifeather.morph.mirror.impl.executors.AbstractExecutor;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.storage.mirrorlogging.OperationType;
import xyz.nifeather.morph.utilities.FoliaThreadUtils;

public class ByNameExecutor
extends AbstractExecutor {
    public ByNameExecutor(ExecutorHub executorHub) {
        super(executorHub);
    }

    @Override
    public void reset() {
    }

    private Optional<LivingEntity> getMirrorTarget(Player source) {
        DisguiseState state = this.morphManager().getDisguiseStateFor(source);
        if (state == null) {
            return Optional.empty();
        }
        if (state.getEntityType() == EntityType.MANNEQUIN) {
            Mannequin result = source.getWorld().getEntitiesByClass(Mannequin.class).stream().filter(m -> this.filterMannequin((Mannequin)m, state)).toList().stream().findFirst().orElse(null);
            return Optional.ofNullable(result);
        }
        String targetName = this.executorHub.getControl(source);
        if (targetName == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(Bukkit.getPlayerExact((String)targetName));
    }

    private boolean filterMannequin(@Nullable Mannequin mannequin, DisguiseState state) {
        if (!FoliaThreadUtils.isTickThreadFor((Entity)mannequin)) {
            return false;
        }
        Component entityName = mannequin.customName();
        Component entityDescription = mannequin.getDescription();
        Object disguiseName = state.disguisePropertyHandler().getOr("entity/custom_name", null);
        Object disguiseDescription = state.disguisePropertyHandler().getOr("mannequin/description", null);
        if (entityName == null && entityDescription == null) {
            return disguiseName == null && disguiseDescription == null;
        }
        return (entityName == null ? disguiseName == null : Objects.equals(entityName, disguiseName)) && (entityDescription == null ? disguiseDescription == null : Objects.equals(entityDescription, disguiseDescription));
    }

    private void scheduleIfNotInSameRegion(LivingEntity target, Runnable consumer) {
        if (!FoliaThreadUtils.isTickThreadFor((Entity)target)) {
            this.scheduleOn((Entity)target, consumer);
        } else {
            consumer.run();
        }
    }

    @Override
    public void onSneak(Player player, boolean sneaking) {
        boolean targetSneaking;
        LivingEntity targetEntity = this.getMirrorTarget(player).orElse(null);
        if (targetEntity == null) {
            return;
        }
        boolean bl = targetSneaking = targetEntity.isSneaking() || targetEntity.getPose().equals((Object)Pose.SNEAKING);
        if (!this.playerInDistance(player, targetEntity) || sneaking == targetSneaking) {
            return;
        }
        this.scheduleIfNotInSameRegion(targetEntity, () -> {
            IOperationHandle<LivingEntity> simulator = this.executorHub.lookupOperationHandle(targetEntity);
            simulator.simulateSneak(targetEntity, sneaking);
            this.logOperation(player, targetEntity, OperationType.ToggleSneak);
        });
    }

    @Override
    public void onSwapHand(Player player) {
        LivingEntity targetEntity = this.getMirrorTarget(player).orElse(null);
        if (targetEntity == null) {
            return;
        }
        if (!this.playerInDistance(player, targetEntity)) {
            return;
        }
        this.scheduleIfNotInSameRegion(targetEntity, () -> {
            this.executorHub.lookupOperationHandle(targetEntity).simulateSwap(targetEntity);
            this.logOperation(player, targetEntity, OperationType.SwapHand);
        });
    }

    @Override
    public void onHotbarChange(Player player, int slot) {
        LivingEntity targetEntity = this.getMirrorTarget(player).orElse(null);
        if (targetEntity == null) {
            return;
        }
        if (!this.playerInDistance(player, targetEntity)) {
            return;
        }
        this.scheduleIfNotInSameRegion(targetEntity, () -> {
            this.executorHub.lookupOperationHandle(targetEntity).scrollHotbar(targetEntity, slot);
            this.logOperation(player, targetEntity, OperationType.HotbarChange);
        });
    }

    @Override
    public void onStopUsingItem(Player player, ItemStack itemStack) {
        LivingEntity targetEntity = this.getMirrorTarget(player).orElse(null);
        if (targetEntity == null) {
            return;
        }
        if (!this.playerInDistance(player, targetEntity)) {
            return;
        }
        this.scheduleIfNotInSameRegion(targetEntity, () -> {
            this.executorHub.lookupOperationHandle(targetEntity).releaseUsingItem(targetEntity, itemStack);
            this.logOperation(player, targetEntity, OperationType.ReleaseUsingItem);
        });
    }

    @Override
    public boolean onHurtEntity(Player damager, LivingEntity hurted) {
        LivingEntity targetEntity = this.getMirrorTarget(damager).orElse(null);
        if (targetEntity == null) {
            return false;
        }
        if (!this.playerInDistance(damager, targetEntity)) {
            return false;
        }
        this.simulateOperationAsync(Action.LEFT_CLICK_AIR, targetEntity, damager, success -> {});
        this.logOperation(damager, targetEntity, OperationType.LeftClick);
        if (FoliaThreadUtils.isTickThreadFor((Entity)targetEntity)) {
            Entity damagerLookingAt = damager.getTargetEntity(5);
            Entity playerLookingAt = targetEntity.getTargetEntity(5);
            if (damagerLookingAt != null && damagerLookingAt.equals((Object)playerLookingAt)) {
                return true;
            }
        }
        return hurted.equals((Object)targetEntity);
    }

    @Override
    public boolean onSwing(Player source) {
        LivingEntity targetEntity = this.getMirrorTarget(source).orElse(null);
        if (targetEntity == null) {
            return false;
        }
        boolean playerInDistance = this.playerInDistance(source, targetEntity);
        if (targetEntity.getLocation().getWorld().equals((Object)source.getLocation().getWorld()) && playerInDistance && FoliaThreadUtils.isTickThreadFor((Entity)targetEntity) && FoliaThreadUtils.isTickThreadFor((Entity)source) && Math.abs(targetEntity.getLocation().distance(source.getLocation())) <= 6.0) {
            Entity theirTarget = targetEntity.getTargetEntity(5);
            Entity ourTarget = source.getTargetEntity(5);
            if ((ourTarget != null || theirTarget != null) && (Objects.equals(ourTarget, targetEntity) || Objects.equals(ourTarget, theirTarget) || Objects.equals(theirTarget, source))) {
                return true;
            }
        }
        if (!playerInDistance) {
            return false;
        }
        PlayerTracker tracker = this.tracker();
        if (tracker.droppingItemThisTick(source)) {
            return false;
        }
        PlayerTracker.InteractType lastAction = tracker.getLastInteractAction(source);
        if (!tracker.interactingThisTick(source)) {
            lastAction = PlayerTracker.InteractType.LEFT_CLICK_AIR;
        }
        if (lastAction == null) {
            return false;
        }
        if (source.getGameMode() == GameMode.SPECTATOR && lastAction.isRightClick()) {
            lastAction = PlayerTracker.InteractType.LEFT_CLICK_BLOCK;
        }
        this.simulateOperationAsync(lastAction.toBukkitAction(), targetEntity, source, success -> {});
        this.logOperation(source, targetEntity, lastAction.isLeftClick() ? OperationType.LeftClick : OperationType.RightClick);
        return false;
    }

    @Override
    public void onInteract(Player source, Action action) {
        if (action == Action.PHYSICAL) {
            return;
        }
        if (this.tracker().isDuplicatedRightClick(source)) {
            if (FeatherMorphMain.getInstance().doInternalDebugOutput) {
                this.logger.info("Interact, Duplicated RC " + System.currentTimeMillis());
            }
            return;
        }
        LivingEntity targetEntity = this.getMirrorTarget(source).orElse(null);
        if (targetEntity == null) {
            return;
        }
        if (!this.playerInDistance(source, targetEntity)) {
            return;
        }
        this.simulateOperationAsync(action, targetEntity, source, success -> {});
        this.logOperation(source, targetEntity, action.isLeftClick() ? OperationType.LeftClick : OperationType.RightClick);
    }
}

