/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.mirror.impl.executors;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.events.PlayerTracker;
import xyz.nifeather.morph.mirror.ExecutorHub;
import xyz.nifeather.morph.mirror.impl.executors.ChainedExecutor;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.storage.mirrorlogging.OperationType;
import xyz.nifeather.morph.utilities.FoliaThreadUtils;

public class BySightExecutor
extends ChainedExecutor {
    public BySightExecutor(ExecutorHub executorHub) {
        super(executorHub);
    }

    @Override
    public void reset() {
    }

    @Override
    @Nullable
    protected LivingEntity findNextControllableEntityFrom(Player source, List<LivingEntity> pendingChain) {
        Mannequin targetEntity;
        block10: {
            Player asPlayer;
            String targetName;
            block12: {
                block11: {
                    Entity lookingAt;
                    block9: {
                        Mannequin mannequin;
                        targetName = this.executorHub.getControl(source);
                        DisguiseState state = this.morphManager().getDisguiseStateFor(source);
                        int lookupDistance = this.executorHub.getControlDistance();
                        if (lookupDistance <= 0) {
                            lookupDistance = 5;
                        }
                        lookingAt = source.getTargetEntity(lookupDistance);
                        targetEntity = null;
                        if (state == null || state.getEntityType() != EntityType.MANNEQUIN) break block9;
                        if (lookingAt instanceof Mannequin && this.filterMannequin(mannequin = (Mannequin)lookingAt, state)) {
                            targetEntity = mannequin;
                        }
                        break block10;
                    }
                    if (!(lookingAt instanceof Player)) break block11;
                    asPlayer = (Player)lookingAt;
                    if (targetName != null) break block12;
                }
                return null;
            }
            if (asPlayer.getName().equals(targetName) && this.morphManager().getDisguiseStateFor(asPlayer) == null) {
                targetEntity = asPlayer;
            }
        }
        if (!FoliaThreadUtils.isTickThreadFor(targetEntity)) {
            return null;
        }
        if (!this.playerInDistance(source, targetEntity)) {
            return null;
        }
        return targetEntity;
    }

    @Override
    public boolean onHurtEntity(Player damager, LivingEntity hurted) {
        LivingEntity simulateTarget = this.findNextControllableEntityFrom(damager, (List)this.currentSimulateChain.get());
        if (simulateTarget == null) {
            return false;
        }
        Entity damagerLookingAt = damager.getTargetEntity(5);
        Entity playerLookingAt = simulateTarget.getTargetEntity(5);
        if (damagerLookingAt != null && damagerLookingAt.equals((Object)playerLookingAt)) {
            return true;
        }
        return hurted.equals((Object)simulateTarget);
    }

    @Override
    public boolean onSwing(Player source) {
        boolean isInChain = this.isInChain((LivingEntity)source);
        if (isInChain) {
            return !this.isLastInChain((LivingEntity)source);
        }
        PlayerTracker tracker = this.tracker();
        if (tracker.droppingItemThisTick(source)) {
            return false;
        }
        PlayerTracker.InteractType lastAction = tracker.getLastInteractAction(source);
        if (!tracker.interactingThisTick(source)) {
            lastAction = PlayerTracker.InteractType.LEFT_CLICK_AIR;
        }
        if (lastAction == null) {
            return false;
        }
        if (source.getGameMode() == GameMode.SPECTATOR && lastAction.isRightClick()) {
            lastAction = PlayerTracker.InteractType.LEFT_CLICK_BLOCK;
        }
        PlayerTracker.InteractType finalLastAction = lastAction;
        AtomicBoolean simulateSuccess = new AtomicBoolean(false);
        this.runIfChainable(source, targetPlayer -> {
            simulateSuccess.set(true);
            this.simulateOperation(finalLastAction.toBukkitAction(), targetPlayer, source);
            this.logOperation(source, (LivingEntity)targetPlayer, finalLastAction.isLeftClick() ? OperationType.LeftClick : OperationType.RightClick);
        });
        return simulateSuccess.get();
    }
}

