/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.mirror.impl.executors;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.mirror.ExecutorHub;
import xyz.nifeather.morph.mirror.impl.executors.AbstractExecutor;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.storage.mirrorlogging.OperationType;
import xyz.nifeather.morph.utilities.FoliaThreadUtils;

public abstract class ChainedExecutor
extends AbstractExecutor {
    protected final ThreadLocal<List<LivingEntity>> currentSimulateChain = ThreadLocal.withInitial(ArrayList::new);

    public ChainedExecutor(ExecutorHub executorHub) {
        super(executorHub);
    }

    protected boolean isInChain(LivingEntity source) {
        List<LivingEntity> list = this.currentSimulateChain.get();
        return list != null && list.contains(source);
    }

    protected boolean isLastInChain(LivingEntity player) {
        List<LivingEntity> list = this.currentSimulateChain.get();
        return list != null && list.indexOf(player) + 1 == list.size();
    }

    protected void runIfChainable(Player source, Consumer<LivingEntity> chainConsumer) {
        List<LivingEntity> currentChain = this.currentSimulateChain.get();
        if (currentChain == null) {
            return;
        }
        if (currentChain.contains(source)) {
            return;
        }
        List<LivingEntity> chain = this.buildSimulateChain(source);
        this.currentSimulateChain.set(chain);
        LivingEntity first = chain.getFirst();
        chain.forEach(pl -> {
            if (!Objects.equals(pl, first)) {
                chainConsumer.accept((LivingEntity)pl);
            }
        });
        currentChain.clear();
        this.currentSimulateChain.remove();
    }

    @Nullable
    protected abstract LivingEntity findNextControllableEntityFrom(Player var1, List<LivingEntity> var2);

    protected List<LivingEntity> buildSimulateChain(Player source) {
        LivingEntity next;
        ObjectArrayList chain = new ObjectArrayList();
        chain.add(source);
        Player current = source;
        while (current != null && !chain.contains(next = this.findNextControllableEntityFrom(current, (List<LivingEntity>)chain)) && next != null) {
            chain.add(next);
            if (next instanceof Player) {
                Player nextAsPlayer;
                current = nextAsPlayer = (Player)next;
                continue;
            }
            current = null;
        }
        return chain;
    }

    @Override
    public void onSneak(Player source, boolean sneaking) {
        this.runIfChainable(source, p -> {
            this.executorHub.lookupOperationHandle(p).simulateSneak((LivingEntity)p, sneaking);
            this.logOperation(source, (LivingEntity)p, OperationType.ToggleSneak);
        });
    }

    protected boolean filterMannequin(@Nullable Mannequin mannequin, DisguiseState state) {
        if (!FoliaThreadUtils.isTickThreadFor((Entity)mannequin)) {
            return false;
        }
        Component entityName = mannequin.customName();
        Component entityDescription = mannequin.getDescription();
        Object disguiseName = state.disguisePropertyHandler().getOr("entity/custom_name", null);
        Object disguiseDescription = state.disguisePropertyHandler().getOr("mannequin/description", null);
        if (entityName == null && entityDescription == null) {
            return disguiseName == null && disguiseDescription == null;
        }
        return (entityName == null ? disguiseName == null : Objects.equals(entityName, disguiseName)) && (entityDescription == null ? disguiseDescription == null : Objects.equals(entityDescription, disguiseDescription));
    }

    @Override
    public void onSwapHand(Player player) {
        this.runIfChainable(player, targetPlayer -> {
            this.executorHub.lookupOperationHandle(targetPlayer).simulateSwap((LivingEntity)targetPlayer);
            this.logOperation(player, (LivingEntity)targetPlayer, OperationType.SwapHand);
        });
    }

    @Override
    public void onHotbarChange(Player player, int slot) {
        this.runIfChainable(player, targetPlayer -> {
            this.executorHub.lookupOperationHandle(targetPlayer).scrollHotbar((LivingEntity)targetPlayer, slot);
            this.logOperation(player, (LivingEntity)targetPlayer, OperationType.HotbarChange);
        });
    }

    @Override
    public void onStopUsingItem(Player player, ItemStack itemStack) {
        this.runIfChainable(player, targetPlayer -> {
            this.executorHub.lookupOperationHandle(targetPlayer).releaseUsingItem((LivingEntity)targetPlayer, itemStack);
            this.logOperation(player, (LivingEntity)targetPlayer, OperationType.ReleaseUsingItem);
        });
    }

    @Override
    public void onInteract(Player source, Action action) {
        if (action == Action.PHYSICAL) {
            return;
        }
        if (this.tracker().isDuplicatedRightClick(source)) {
            if (FeatherMorphMain.getInstance().doInternalDebugOutput) {
                this.logger.info("Interact, Duplicated RC " + System.currentTimeMillis());
            }
            return;
        }
        this.runIfChainable(source, targetPlayer -> {
            this.simulateOperation(action, targetPlayer, source);
            this.logOperation(source, (LivingEntity)targetPlayer, action.isLeftClick() ? OperationType.LeftClick : OperationType.RightClick);
        });
    }
}

