/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.RevealingHandler;
import xyz.nifeather.morph.abilities.AbilityUpdater;
import xyz.nifeather.morph.api.morphs.skills.SkillNames;
import xyz.nifeather.morph.backends.DisguiseWrapper;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.strings.CommandStrings;
import xyz.nifeather.morph.messages.strings.EmoteStrings;
import xyz.nifeather.morph.messages.strings.MorphStrings;
import xyz.nifeather.morph.misc.AnimationSequence;
import xyz.nifeather.morph.misc.CacheWithDefault;
import xyz.nifeather.morph.misc.CachedMessageStatus;
import xyz.nifeather.morph.misc.DisguiseEquipment;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.misc.EarlyDisposeException;
import xyz.nifeather.morph.misc.SoundHandler;
import xyz.nifeather.morph.misc.UpdateFailedException;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityPropertyCollection;
import xyz.nifeather.morph.misc.gui.IconLookup;
import xyz.nifeather.morph.misc.permissions.CommonPermissions;
import xyz.nifeather.morph.misc.waypoint.DisguiseWaypointTransmitter;
import xyz.nifeather.morph.network.PlayerOptions;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.S2CPlayAnimationCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetAnimationDisplayNameCommand;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.providers.animation.SingleAnimation;
import xyz.nifeather.morph.providers.disguise.DisguiseProvider;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;
import xyz.nifeather.morph.skills.ISkill;
import xyz.nifeather.morph.skills.SkillManager;
import xyz.nifeather.morph.skills.SkillUpdater;
import xyz.nifeather.morph.skills.impl.NoneMorphSkill;
import xyz.nifeather.morph.storage.playerdata.PlayerMeta;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;
import xyz.nifeather.morph.utilities.NbtUtils;
import xyz.nifeather.morph.utilities.PermissionUtils;

public class DisguiseState
extends MorphPluginObject {
    private final AtomicBoolean sequencePersistent = new AtomicBoolean(false);
    @Resolved(shouldSolveImmediately=true)
    private SkillManager skillManager;
    @Resolved(shouldSolveImmediately=true)
    private MorphClientHandler clientHandler;
    private final List<Object> disableSkillRequests = Collections.synchronizedList(new ObjectArrayList());
    private final List<Object> disableAmbientRequests = Collections.synchronizedList(new ObjectArrayList());
    private final List<Object> disableBossbarRequests = Collections.synchronizedList(new ObjectArrayList());
    private final PlayerOptions<Player> playerOptions;
    private final PlayerMeta morphConfiguration;
    private final AnimationSequence animationSequence = new AnimationSequence();
    private final UUID playerUUID;
    @NotNull
    private final CacheWithDefault<Player> cachedPlayer;
    private boolean serverSideSelfVisible;
    private static final Component fallbackDisplay = Component.text((String)"~UNDEFINED~");
    @Nullable
    private Component playerDisplay;
    @Nullable
    private Component serverDisplay;
    public Component entityCustomName;
    @NotNull
    private final DisguiseWrapper<?> disguiseWrapper;
    private String disguiseIdentifier = SkillNames.UNKNOWN.asString();
    private DisguiseTypes disguiseType;
    private DisguiseProvider provider;
    @Nullable
    private BossBar bossbar;
    private final PropertyHandler propertyHandler = new PropertyHandler();
    private final Map<String, Object> propertiesMap = new Object2ObjectArrayMap();
    @Nullable
    private String skillLookupIdentifier = null;
    private static final String DEFAULT_SKILL_LOOKUP = "minecraft:@default";
    private final SkillUpdater skillUpdater = new SkillUpdater(this);
    private final DisguiseWaypointTransmitter disguiseWaypointTransmitter;
    @NotNull
    private final AbilityUpdater abilityUpdater;
    private final CompletableFuture<DisguiseState> stateFuture = new CompletableFuture();
    private volatile boolean selfUpdateBegan;
    @Nullable
    private volatile ScheduledTask loopTask;
    private volatile boolean exceptionOnce = false;
    @Resolved
    private RevealingHandler revealingHandler;
    @Nullable
    private CachedMessageStatus cachedMessageStatus;
    private volatile boolean requestedActionbarUpdate;
    private final SoundHandler soundHandler;
    private final AtomicBoolean disposed = new AtomicBoolean(false);

    public DisguiseState(@NotNull Player player, @NotNull String identifier, @NotNull String skillIdentifier, @NotNull DisguiseWrapper<?> wrapper, @NotNull DisguiseProvider provider, @NotNull PlayerOptions<Player> playerOptions, @NotNull PlayerMeta playerMeta) {
        Objects.requireNonNull(wrapper, "Wrapper cannot be null.");
        Objects.requireNonNull(identifier, "Disguise identifier cannot be null.");
        Objects.requireNonNull(skillIdentifier, "Skill identifier cannot be null.");
        Objects.requireNonNull(provider, "Disguise provider cannot be null");
        Objects.requireNonNull(playerOptions, "Player options cannot be null");
        Objects.requireNonNull(playerMeta, "Player metadata cannot be null");
        this.playerUUID = player.getUniqueId();
        this.provider = provider;
        this.playerOptions = playerOptions;
        this.morphConfiguration = playerMeta;
        this.soundHandler = new SoundHandler(player);
        this.abilityUpdater = new AbilityUpdater(this);
        this.disguiseWaypointTransmitter = new DisguiseWaypointTransmitter(this);
        this.disguiseWrapper = wrapper;
        this.disguiseIdentifier = identifier;
        this.skillLookupIdentifier(skillIdentifier);
        this.disguiseType = DisguiseTypes.fromId(identifier);
        this.provider = MorphManager.getProvider(identifier);
        this.soundHandler.refreshSounds(this, wrapper.getEntityType(), wrapper.isBaby());
        this.cachedPlayer = CacheWithDefault.of(player);
        this.animationSequence.setCooldown(10);
        this.animationSequence.onNewAnimation(anim -> {
            String animSubId = anim.subId();
            if (anim.availableForClient()) {
                this.clientHandler.sendCommand(this.getPlayer(), (AbstractS2CCommand<?>)new S2CPlayAnimationCommand(animSubId));
            }
            this.getDisguiseWrapper().playAnimation(animSubId);
            if (animSubId.startsWith("exec_")) {
                this.handleInternalExec(animSubId);
            }
        });
        this.animationSequence.onNewAnimationSequence(newAnimSeqId -> this.clientHandler.sendCommand(this.getPlayer(), (AbstractS2CCommand<?>)new S2CSetAnimationDisplayNameCommand((String)newAnimSeqId)));
        this.disguisePropertyHandler().hookOnPropertyWrite(this::onPropertyWrite);
    }

    private void onPropertyWrite(SingleProperty<?> singleProperty, Object o) {
        switch (singleProperty.id()) {
            case "entity/custom_name": {
                Component component = (Component)o;
                this.setCustomDisplayName(component);
                this.requestActionbarUpdate();
                break;
            }
            case "mannequin/skin": 
            case "player/skin": {
                this.requestActionbarUpdate();
            }
        }
        this.disguiseWrapper.writeProperty(singleProperty, o);
    }

    private void handleInternalExec(String animationSubId) {
        switch (animationSubId) {
            case "exec_disable_ambient": {
                this.requestAmbientState(this, true);
                break;
            }
            case "exec_enable_ambient": {
                this.requestAmbientState(this, false);
                break;
            }
            case "exec_disable_skill": {
                this.requestSkillState(this, true);
                break;
            }
            case "exec_enable_skill": {
                this.requestSkillState(this, false);
                break;
            }
            case "exec_disable_bossbar": {
                this.requestBossbarState(this, true);
                break;
            }
            case "exec_enable_bossbar": {
                this.requestBossbarState(this, false);
            }
        }
    }

    public void requestSkillState(Object source, boolean shouldDisable) {
        if (shouldDisable) {
            if (!this.disableSkillRequests.contains(source)) {
                this.disableSkillRequests.add(source);
            }
        } else {
            this.disableSkillRequests.remove(source);
        }
    }

    public boolean canActivateSkill() {
        return this.disableSkillRequests.isEmpty();
    }

    public void requestAmbientState(Object source, boolean shouldDisable) {
        if (shouldDisable) {
            if (!this.disableAmbientRequests.contains(source)) {
                this.disableAmbientRequests.add(source);
            }
        } else {
            this.disableAmbientRequests.remove(source);
        }
    }

    public boolean canPlayAmbient() {
        return this.disableSkillRequests.isEmpty();
    }

    public void requestBossbarState(Object source, boolean shouldDisable) {
        if (shouldDisable) {
            if (!this.disableBossbarRequests.contains(source)) {
                this.disableBossbarRequests.add(source);
            }
        } else {
            this.disableBossbarRequests.remove(source);
        }
    }

    public boolean canDisplayBossbar() {
        return this.disableBossbarRequests.isEmpty();
    }

    public void stopAnimations() {
        this.animationSequence.reset();
    }

    public void onPlayerQuit() {
        this.stopAnimations();
        this.abilityUpdater.onPlayerOffline();
        this.getDisguiseWrapper().onPlayerOffline();
        this.getProvider().onPlayerQuitWithDisguise(this);
    }

    @ApiStatus.Internal
    public void onPlayerJoin() {
        this.abilityUpdater.reApplyAbility();
        this.skillUpdater.onPlayerJoin();
        this.getProvider().onPlayerJoinWithDisguise(this);
        this.getDisguiseWrapper().onPlayerJoin(this.getPlayer());
        ScheduledTask currentLoopTask = this.loopTask;
        if (currentLoopTask == null || currentLoopTask.isCancelled()) {
            this.scheduleSelfUpdate();
        }
    }

    public boolean canScheduleSequence() {
        return this.skillUpdater.calculateRemainingCooldown() <= 0L;
    }

    public boolean tryScheduleSequence(@NotNull String sequenceIdentifier, List<SingleAnimation> sequence, boolean persistent) {
        if (!this.canScheduleSequence()) {
            return false;
        }
        this.scheduleSequence(sequenceIdentifier, sequence, persistent);
        return true;
    }

    public void scheduleSequence(String sequenceIdentifier, List<SingleAnimation> sequence, boolean persistent) {
        this.scheduleSequence(sequenceIdentifier, sequence, true, persistent);
    }

    private void scheduleSequence(String sequenceIdentifier, List<SingleAnimation> sequence, boolean checkPermission, boolean persistent) {
        Player player = this.getPlayer();
        if (checkPermission && sequenceIdentifier.equals("reset") || !PermissionUtils.hasPermission(player, CommonPermissions.animationPermissionOf(sequenceIdentifier, this.getDisguiseIdentifier()), true)) {
            MessageUtils.send((CommandSender)player, CommandStrings.noPermissionMessage());
            return;
        }
        this.animationSequence.scheduleNext(sequenceIdentifier, sequence);
        this.sequencePersistent.set(persistent);
        FormattableMessage animationString = CommandStrings.goingToPlayAnimation().resolve("what", EmoteStrings.get(sequenceIdentifier));
        MessageUtils.send((CommandSender)player, animationString);
    }

    public AnimationSequence getAnimationSequence() {
        return this.animationSequence;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    @NotNull
    public Player getPlayer() {
        Player cached = this.cachedPlayer.get();
        if (cached.isConnected()) {
            return cached;
        }
        Player newPlayer = Bukkit.getPlayer((UUID)this.playerUUID);
        if (newPlayer == null) {
            return cached;
        }
        return this.cachedPlayer.set(newPlayer);
    }

    public boolean getServerSideSelfVisible() {
        return this.serverSideSelfVisible;
    }

    public boolean isClientSideSelfViewing() {
        return this.playerOptions.isClientSideSelfView();
    }

    public boolean isSelfViewing() {
        return this.playerOptions.isClientSideSelfView() ? this.morphConfiguration.showDisguiseToSelf : this.serverSideSelfVisible;
    }

    public void setServerSideSelfVisible(boolean val) {
        this.disguiseWrapper.setServerSelfView(val);
        this.serverSideSelfVisible = val;
    }

    @NotNull
    public Component getPlayerDisplay() {
        return this.playerDisplay == null ? fallbackDisplay : this.playerDisplay;
    }

    public void setPlayerDisplay(@NotNull Component newName) {
        this.playerDisplay = newName;
    }

    @NotNull
    public Component getServerDisplay() {
        return this.serverDisplay == null ? fallbackDisplay : this.serverDisplay;
    }

    public void setServerDisplay(@NotNull Component newName) {
        this.serverDisplay = newName;
    }

    public void setCustomDisplayName(Component newName) {
        this.setPlayerDisplay(newName);
        this.setServerDisplay(newName);
    }

    @NotNull
    public DisguiseWrapper<?> getDisguiseWrapper() {
        return this.disguiseWrapper;
    }

    public String getDisguiseIdentifier() {
        return this.disguiseIdentifier;
    }

    public EntityType getEntityType() {
        return this.disguiseWrapper.getEntityType();
    }

    public DisguiseTypes getDisguiseType() {
        return this.disguiseType;
    }

    @NotNull
    public DisguiseProvider getProvider() {
        return this.provider;
    }

    @Nullable
    public BossBar getBossbar() {
        return this.bossbar;
    }

    public void setBossbar(@Nullable BossBar bossbar) {
        if (this.bossbar != null) {
            this.featherMorph().getPlatform().onlinePlayersNative().forEach(p -> p.hideBossBar(this.bossbar));
        }
        this.bossbar = bossbar;
    }

    public PropertyHandler disguisePropertyHandler() {
        return this.propertyHandler;
    }

    public void setSessionData(String name, Object value) {
        if (value == null) {
            this.removeSessionData(name);
            return;
        }
        this.propertiesMap.put(name, value);
    }

    @Nullable
    public <T> T getSessionData(String name, Class<T> type) {
        T value = this.propertiesMap.getOrDefault(name, null);
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return value;
        }
        return null;
    }

    @NotNull
    public <T> T getSessionDataOr(String name, Class<T> type, @NotNull T defaultVal) {
        T data = this.getSessionData(name, type);
        return data == null ? defaultVal : data;
    }

    public void removeSessionData(String name) {
        this.propertiesMap.remove(name);
    }

    @NotNull
    public String skillLookupIdentifier() {
        return this.skillLookupIdentifier == null ? DEFAULT_SKILL_LOOKUP : this.skillLookupIdentifier;
    }

    public void skillLookupIdentifier(@NotNull String newSkillID) {
        this.skillLookupIdentifier = newSkillID;
    }

    private void postExecuteSkill() {
        this.soundHandler.resetSoundTime();
    }

    public void setDefaultSkillCooldown(int cd) {
        this.skillUpdater.defaultSkillCooldown = Math.max(0, cd);
    }

    public boolean skillInCooldown() {
        return this.plugin.getCurrentTick() < this.skillUpdater.getAvailableAfter();
    }

    public int getDefaultSkillCooldown() {
        return this.skillUpdater.defaultSkillCooldown;
    }

    public boolean executeSkillCheckPermission() {
        if (this.skillUpdater.executeSkillCheckPermission()) {
            this.postExecuteSkill();
            return true;
        }
        return false;
    }

    public boolean executeSkillDirect() {
        if (this.skillUpdater.executeSkill()) {
            this.postExecuteSkill();
            return true;
        }
        return false;
    }

    public <O extends ISkillAbilityOption> void bindSkill(@Nullable ISkill<O> newSkill, O option) {
        this.skillUpdater.bindSkill(newSkill, option);
    }

    @NotNull
    public ISkill<?> getSkill() {
        return this.skillUpdater.getBindingSkill();
    }

    public boolean haveSkill() {
        return this.skillUpdater.getBindingSkill() != NoneMorphSkill.instance;
    }

    public long calculateRemainingCooldown() {
        return this.skillUpdater.calculateRemainingCooldown();
    }

    public void setSkillCooldown(long val, boolean notifyClient) {
        this.skillUpdater.setCooldown(val, notifyClient);
    }

    public void setAvailableAfter(long val, boolean notifyClient) {
        this.skillUpdater.setAvailableAfter(val, notifyClient);
    }

    public void applyCooldownToClient() {
        this.skillUpdater.applyCooldownToClient();
    }

    public DisguiseWaypointTransmitter waypointTransmitter() {
        return this.disguiseWaypointTransmitter;
    }

    @NotNull
    public AbilityUpdater getAbilityUpdater() {
        return this.abilityUpdater;
    }

    public boolean containsAbility(NamespacedKey key) {
        return this.abilityUpdater.containsAbility(key);
    }

    @Deprecated
    public String getCulledNbtString() {
        return NbtUtils.getCompoundString(this.disguiseWrapper.getCompound());
    }

    public CompletableFuture<DisguiseState> getStateFuture() {
        CompletableFuture<DisguiseState> instance = new CompletableFuture<DisguiseState>();
        this.stateFuture.thenAccept(instance::complete);
        this.stateFuture.exceptionally(t -> {
            instance.completeExceptionally((Throwable)t);
            return null;
        });
        return instance;
    }

    public void scheduleSelfUpdate() throws UnsupportedOperationException {
        ScheduledTask currentLoopTask = this.loopTask;
        if (currentLoopTask != null && !currentLoopTask.isCancelled()) {
            throw new UnsupportedOperationException("Scheduling update loop while an existing loop is running");
        }
        this.loopTask = this.getPlayer().getScheduler().runAtFixedRate((Plugin)this.plugin, this::updateLoop, this::onEntityRetired, 1L, 1L);
    }

    private void updateLoop(ScheduledTask task) {
        if (!task.isCancelled()) {
            this.doUpdate();
        }
    }

    private void onEntityRetired() {
    }

    private synchronized void doUpdate() {
        if (this.disposed()) {
            return;
        }
        if (!this.selfUpdateBegan) {
            this.selfUpdateBegan = true;
        }
        try {
            Player player = this.getPlayer();
            if (player.isOnline()) {
                if (!this.getProvider().updateDisguise(player, this)) {
                    throw new UpdateFailedException("Failed executing provider update");
                }
                this.selfUpdate();
            }
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    public void handleException(Throwable t) {
        if (!this.exceptionOnce) {
            this.exceptionOnce = true;
            this.logger.error("Error occurred with disguise", t);
            this.stateFuture.completeExceptionally(t);
        } else {
            this.logger.warn("Error occurred with disguise (Has earlier exception, not triggering)", t);
        }
    }

    public void selfUpdate() {
        if (this.canPlayAmbient()) {
            this.getSoundHandler().update();
        }
        this.animationSequence.update();
        this.disguiseWaypointTransmitter.tick();
        this.skillUpdater.update();
        this.disguiseWrapper.update();
        this.abilityUpdater.update();
        if (this.playerOptions.displayDisguiseOnHUD && this.plugin.getCurrentTick() % (long)(this.haveSkill() ? 2 : 5) == 0L) {
            this.updateActionbarMessage();
        }
    }

    public void requestActionbarUpdate() {
        this.requestedActionbarUpdate = true;
    }

    private void updateActionbarMessage() {
        short stateBit;
        Player player = this.getPlayer();
        String locale = MessageUtils.getLocale(player);
        boolean haveSkill = this.haveSkill();
        boolean updateAnyway = this.requestedActionbarUpdate;
        this.requestedActionbarUpdate = false;
        short magicBit = 0;
        if (haveSkill) {
            magicBit = (short)(magicBit | 1);
        }
        magicBit = this.skillInCooldown() ? (short)(magicBit | 2) : (short)(magicBit | 4);
        RevealingHandler.RevealingLevel revLevel = this.revealingHandler.getRevealingLevel(player);
        switch (revLevel) {
            case SAFE: {
                magicBit = (short)(magicBit | 8);
                break;
            }
            case SUSPECT: {
                magicBit = (short)(magicBit | 0x10);
                break;
            }
            case REVEALED: {
                magicBit = (short)(magicBit | 0x20);
            }
        }
        magicBit = (short)(magicBit | (short)locale.hashCode());
        CachedMessageStatus msgConfig = this.cachedMessageStatus;
        if (msgConfig == null) {
            msgConfig = CachedMessageStatus.DEFAULT;
        }
        if ((stateBit = msgConfig.statusBit()) != magicBit || updateAnyway) {
            boolean disguiseRevealed;
            FormattableMessage msg = haveSkill ? (!this.skillInCooldown() ? MorphStrings.disguisingWithSkillAvaliableString() : MorphStrings.disguisingWithSkillPreparingString()) : MorphStrings.disguisingAsString();
            boolean bl = disguiseRevealed = revLevel == RevealingHandler.RevealingLevel.REVEALED || revLevel == RevealingHandler.RevealingLevel.SUSPECT;
            Component display = disguiseRevealed ? this.getPlayerDisplay().append((revLevel == RevealingHandler.RevealingLevel.REVEALED ? MorphStrings.revealed() : MorphStrings.partialRevealed()).createComponent(locale)) : this.getPlayerDisplay();
            this.cachedMessageStatus = msgConfig = new CachedMessageStatus(magicBit, msg.resolve("what", display).resolve("icon", IconLookup.instance().lookupDisguiseIcon(this)).createComponent(locale));
        }
        player.sendActionBar(msgConfig.display());
    }

    public boolean showingDisguisedItems() {
        return this.propertyHandler.getOr("entity/display_disguise_equipment", Boolean.valueOf(false));
    }

    public void editEquipment(Consumer<DisguiseEquipment> consumer) {
        DisguiseEquipment equipment = this.getDisguiseEquipment();
        consumer.accept(equipment);
        this.setEquipment(equipment);
    }

    public void setEquipment(DisguiseEquipment equipment) {
        BaseLivingEntityPropertyCollection properties = DisguiseProperties.INSTANCE.getCollectionOrThrow(BaseLivingEntityPropertyCollection.class);
        this.propertyHandler.set(properties.EQUIPMENT, equipment);
    }

    public void setShowingDisguisedEquipment(boolean value) {
        BaseLivingEntityPropertyCollection properties = DisguiseProperties.INSTANCE.getCollectionOrThrow(BaseLivingEntityPropertyCollection.class);
        this.propertyHandler.set(properties.DISPLAY_DISGUISE_EQUIPMENT, value);
    }

    public DisguiseEquipment getDisguiseEquipment() {
        BaseLivingEntityPropertyCollection properties = DisguiseProperties.INSTANCE.getCollectionOrThrow(BaseLivingEntityPropertyCollection.class);
        return this.propertyHandler.getOptional(properties.EQUIPMENT).orElseGet(DisguiseEquipment::empty);
    }

    public boolean toggleDisguisedItems() {
        boolean showDisguisedItems = this.showingDisguisedItems();
        this.setShowingDisguisedEquipment(!showDisguisedItems);
        return !showDisguisedItems;
    }

    public SoundHandler getSoundHandler() {
        return this.soundHandler;
    }

    public DisguiseState createCopy(Player player) {
        if (this.disposed()) {
            throw new RuntimeException("Can't create a copy of a disposed DisguiseState");
        }
        Object wrapper = this.disguiseWrapper.clone();
        DisguiseState newInstance = new DisguiseState(player, this.disguiseIdentifier, this.skillLookupIdentifier(), (DisguiseWrapper<?>)wrapper, this.provider, this.playerOptions, this.morphConfiguration);
        newInstance.playerDisplay = this.playerDisplay;
        newInstance.serverDisplay = this.serverDisplay;
        return newInstance;
    }

    public boolean disposed() {
        return this.disposed.get();
    }

    @Override
    public synchronized void dispose() {
        if (this.disposed()) {
            return;
        }
        if (this.selfUpdateBegan) {
            this.stateFuture.complete(this);
        } else {
            this.stateFuture.completeExceptionally(new EarlyDisposeException("The DisguiseState has been disposed before running once"));
        }
        this.disposed.set(true);
        this.waypointTransmitter().dispose();
        this.disguiseWrapper.dispose();
        this.abilityUpdater.dispose();
        this.propertyHandler.dispose();
        this.provider.unMorph(this.getPlayer(), this);
        this.abilityUpdater.setAbilities(List.of());
        this.skillUpdater.submitCooldown(this.skillManager.cooldownManager());
        this.bindSkill(null, null);
    }
}

