/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc;

import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.api.morphs.skills.SkillNames;
import xyz.nifeather.morph.backends.DisguiseBackend;
import xyz.nifeather.morph.backends.DisguiseWrapper;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.network.PlayerOptions;
import xyz.nifeather.morph.providers.disguise.DisguiseProvider;
import xyz.nifeather.morph.skills.SkillManager;
import xyz.nifeather.morph.storage.offlinestore.OfflineDisguiseState;
import xyz.nifeather.morph.storage.playerdata.PlayerMeta;

public class DisguiseStateGenerator {
    public static OfflineDisguiseState toOfflineState(DisguiseState state) {
        OfflineDisguiseState offlineState = new OfflineDisguiseState();
        offlineState.playerUUID = state.getPlayer().getUniqueId();
        offlineState.playerName = state.getPlayer().getName();
        offlineState.disguiseID = state.getDisguiseIdentifier();
        Object newDisguise = state.getDisguiseWrapper().clone();
        DisguiseBackend backend = ((DisguiseWrapper)newDisguise).getBackend();
        offlineState.disguiseData = "%s|%s".formatted(backend.getIdentifier(), backend.toOfflineSave((DisguiseWrapper<?>)newDisguise));
        offlineState.displayingDisguisedItems = state.showingDisguisedItems();
        if (state.entityCustomName != null) {
            offlineState.customName = (String)GsonComponentSerializer.gson().serialize(state.entityCustomName);
        }
        return offlineState;
    }

    public static DisguiseState fromOfflineState(OfflineDisguiseState offlineState, PlayerOptions<Player> playerOptions, PlayerMeta playerMeta, SkillManager skillHandler, DisguiseBackend<?, ?> backend) {
        if (!offlineState.isValid()) {
            throw new RuntimeException("Broken Offline State for UUID '%s'".formatted(offlineState.playerUUID));
        }
        Player player = Bukkit.getPlayer((UUID)offlineState.playerUUID);
        if (player == null) {
            throw new RuntimeException("No matching player found for UUID '%s'".formatted(offlineState.playerUUID));
        }
        String disguiseIdentifier = offlineState.disguiseID;
        DisguiseProvider provider = MorphManager.getProvider(disguiseIdentifier);
        boolean rawIdentifierHasSkill = skillHandler.hasSkill(disguiseIdentifier) || skillHandler.hasSpeficSkill(disguiseIdentifier, SkillNames.NONE);
        String targetSkillID = rawIdentifierHasSkill ? disguiseIdentifier : provider.getNameSpace() + ":@default";
        Object wrapper = backend.fromOfflineSave(offlineState.disguiseData);
        if (wrapper == null) {
            return null;
        }
        if (provider.getNameSpace().equals("player")) {
            String playerName = DisguiseTypes.PLAYER.toStrippedId(disguiseIdentifier);
            ((DisguiseWrapper)wrapper).setDisguiseName(playerName);
        }
        DisguiseState state = new DisguiseState(player, disguiseIdentifier, targetSkillID, (DisguiseWrapper<?>)wrapper, provider, playerOptions, playerMeta);
        if (offlineState.customName != null) {
            Component component;
            state.entityCustomName = component = GsonComponentSerializer.gson().deserialize((Object)offlineState.customName);
            state.setCustomDisplayName(component);
        }
        state.setShowingDisguisedEquipment(offlineState.displayingDisguisedItems);
        return state;
    }
}

